/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.loader.RESTLoader;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/transaction")
@Api(value="/transaction", description="Endpoints to load new batched Graql queries and query the status of a specific transaction.")
@Produces(value={"text/plain"})
public class TransactionController {
    RESTLoader loader;
    String defaultGraphName = ConfigProperties.getInstance().getProperty("graphdatabase.default-graph-name");
    private final Logger LOG = LoggerFactory.getLogger(TransactionController.class);

    public TransactionController() {
        this.loader = RESTLoader.getInstance();
        Spark.get((String)"/transaction/loaderState", this::loaderState);
        Spark.post((String)"/transaction/new", this::newTransactionREST);
        Spark.get((String)"/transaction/status/:uuid", this::checkTransactionStatusREST);
    }

    @POST
    @Path(value="/new")
    @ApiOperation(value="Load a new transaction made of Graql insert queries into the graph.", notes="The body of the request should be a JSON array of the insert Graql strings.")
    @ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query")
    private String newTransactionREST(Request req, Response res) {
        UUID uuid;
        String currentGraphName = req.queryParams("graphName");
        if (currentGraphName == null) {
            currentGraphName = this.defaultGraphName;
        }
        if ((uuid = this.loader.addJob(currentGraphName, Json.read((String)req.body()))) != null) {
            res.status(201);
            return uuid.toString();
        }
        throw new GraknEngineServerException(500, "Error while trying to load a new transaction.");
    }

    @GET
    @Path(value="/status/:uuid")
    @ApiOperation(value="Returns the status of the transaction associated to the given UUID.")
    @ApiImplicitParam(name="uuid", value="UUID of the transaction", required=true, dataType="string", paramType="path")
    private String checkTransactionStatusREST(Request req, Response res) {
        try {
            return this.loader.getStatus(UUID.fromString(req.params(":uuid")));
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    @GET
    @Path(value="/loaderState")
    @ApiOperation(value="Returns the state of the RESTLoader.")
    private String loaderState(Request req, Response res) {
        try {
            return this.loader.getLoaderState();
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }
}

