/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.engine.visualiser.HALConceptRepresentationBuilder;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Reasoner;
import ai.grakn.graql.internal.printer.Printers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/graph")
@Api(value="/graph", description="Endpoints used to query the graph by ID or Graql match query and build HAL objects.")
@Produces(value={"application/json", "text/plain"})
public class VisualiserController {
    private final Logger LOG = LoggerFactory.getLogger(VisualiserController.class);
    private String defaultGraphName = ConfigProperties.getInstance().getProperty("graphdatabase.default-graph-name");
    private int separationDegree = ConfigProperties.getInstance().getPropertyAsInt("halBuilder.degree");
    private static final String SHORTEST_PATH_QUERY = "path";
    private static final String COMPUTE_RESPONSE_TYPE = "type";
    private static final String COMPUTE_RESPONSE_FIELD = "response";

    public VisualiserController() {
        Spark.get((String)"/graph/concept/:id", this::getConceptById);
        Spark.get((String)"/graph/concept/ontology/:id", this::getConceptByIdOntology);
        Spark.get((String)"/graph/match", this::matchQuery);
        Spark.get((String)"/graph/analytics", this::computeQuery);
        Spark.get((String)"/graph/preMaterialiseAll", this::preMaterialiseAll);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/concept/:uuid")
    @ApiOperation(value="Return the HAL representation of a given concept.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID of the concept", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query")})
    private String getConceptById(Request req, Response res) {
        String graphNameParam = req.queryParams("graphName");
        String currentGraphName = graphNameParam == null ? this.defaultGraphName : graphNameParam;
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            Concept concept = graph.getConcept(req.params(":id"));
            this.LOG.trace("Building HAL resource for concept with id {}", (Object)concept.getId());
            String string = HALConceptRepresentationBuilder.renderHALConceptData(concept, this.separationDegree);
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/concept/ontology/:uuid")
    @ApiOperation(value="Return the HAL representation of a given concept.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID of the concept", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query")})
    private String getConceptByIdOntology(Request req, Response res) {
        String graphNameParam = req.queryParams("graphName");
        String currentGraphName = graphNameParam == null ? this.defaultGraphName : graphNameParam;
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            Concept concept = graph.getConcept(req.params(":id"));
            this.LOG.trace("Building HAL resource for concept with id {}", (Object)concept.getId());
            String string = HALConceptRepresentationBuilder.renderHALConceptOntology(concept);
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/match")
    @ApiOperation(value="Executes match query on the server and build HAL representation for each concept in the query result.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Match query to execute", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="reasoner", value="Boolean used to decide whether run reasoner together with the current query.", required=true, dataType="sting/boolean", paramType="query")})
    private String matchQuery(Request req, Response res) {
        String currentGraphName = req.queryParams("graphName");
        if (currentGraphName == null) {
            currentGraphName = this.defaultGraphName;
        }
        boolean useReasoner = Boolean.parseBoolean(req.queryParams("reasoner"));
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            MatchQuery currentMatchQuery;
            this.LOG.debug("Start querying for: [{}]", (Object)req.queryParams("query"));
            MatchQuery matchQuery = (MatchQuery)graph.graql().parse(req.queryParams("query"));
            if (useReasoner) {
                currentMatchQuery = new Reasoner(graph).resolveToQuery(matchQuery, true);
                graph.commit();
            } else {
                currentMatchQuery = matchQuery;
            }
            Collection graqlResultsList = currentMatchQuery.stream().collect(Collectors.toList());
            graph.commit();
            this.LOG.debug("Done querying, " + graqlResultsList.size() + " results found");
            JSONArray halArray = HALConceptRepresentationBuilder.renderHALArrayData(matchQuery, graqlResultsList);
            this.LOG.debug("Done building resources.");
            String string = halArray.toString();
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/analytics")
    @ApiOperation(value="Executes compute query on the server and build HAL representation of result or returns string containing statistics.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Compute query to execute", required=true, dataType="string", paramType="query")})
    private String computeQuery(Request req, Response res) {
        String currentGraphName = req.queryParams("graphName");
        if (currentGraphName == null) {
            currentGraphName = this.defaultGraphName;
        }
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            String query = req.queryParams("query");
            this.LOG.debug("Start querying for: [{}]", (Object)query);
            JSONObject responseObject = new JSONObject();
            ComputeQuery computeQuery = (ComputeQuery)graph.graql().parse(req.queryParams("query"));
            if (query.contains(SHORTEST_PATH_QUERY)) {
                responseObject.put(COMPUTE_RESPONSE_TYPE, (Object)"HAL");
                JSONArray array = new JSONArray();
                ((List)computeQuery.execute()).iterator().forEachRemaining(concept -> array.put((Object)HALConceptRepresentationBuilder.renderHALConceptData(concept, 0)));
                responseObject.put(COMPUTE_RESPONSE_FIELD, (Object)array);
            } else {
                responseObject.put(COMPUTE_RESPONSE_TYPE, (Object)"string");
                responseObject.put(COMPUTE_RESPONSE_FIELD, (Object)computeQuery.resultsString(Printers.graql()).map(x -> x.replaceAll("\u001b\\[\\d+[m]", "")).collect(Collectors.joining()));
            }
            String string = responseObject.toString();
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/preMaterialiseAll")
    @ApiOperation(value="Pre materialise all the rules on the graph.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query")})
    private String preMaterialiseAll(Request req, Response res) {
        String currentGraphName = req.queryParams("graphName");
        if (currentGraphName == null) {
            currentGraphName = this.defaultGraphName;
        }
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            new Reasoner(graph).precomputeInferences();
            String string = "Done.";
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }
}

