/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.GraknGraph;
import ai.grakn.engine.loader.Loader;
import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.graql.InsertQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BlockingLoader
extends Loader {
    private static ConfigProperties prop = ConfigProperties.getInstance();
    private static int repeatCommits = prop.getPropertyAsInt("loader.repeat-commits");
    private static Cache cache = Cache.getInstance();
    private static Semaphore transactionsSemaphore;
    private ExecutorService executor;
    private String graphName;

    public BlockingLoader(String graphName) {
        this.setBatchSize(prop.getPropertyAsInt("blockingLoader.batch-size"));
        this.setThreadsNumber(prop.getAvailableThreads());
        this.initExecutor();
        this.initSemaphore();
        this.graphName = graphName;
    }

    public void setExecutorSize(int size) {
        this.shutdownExecutor();
        this.setThreadsNumber(size);
        this.initExecutor();
        this.initSemaphore();
    }

    @Override
    public void waitToFinish() {
        this.flush();
        this.shutdownExecutor();
        this.initExecutor();
    }

    @Override
    protected void sendQueriesToLoader(Collection<InsertQuery> queries) {
        try {
            transactionsSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ArrayList<InsertQuery> deepCopy = new ArrayList<InsertQuery>(queries);
        try {
            this.executor.submit(() -> this.insertQueriesInOneTransaction(this.graphName, deepCopy));
        }
        catch (Exception e) {
            this.LOG.error("Exception ", (Throwable)e);
            transactionsSemaphore.release();
        }
    }

    /*
     * Exception decompiling
     */
    private void insertQueriesInOneTransaction(String name, Collection<InsertQuery> queries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void shutdownExecutor() {
        if (this.executor == null) {
            return;
        }
        try {
            this.executor.shutdown();
            this.LOG.info("All tasks submitted, waiting for termination..");
            boolean finished = this.executor.awaitTermination(5L, TimeUnit.MINUTES);
            if (finished) {
                this.LOG.info("All tasks done.");
            } else {
                this.LOG.warn("Loading exceeded timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void initExecutor() {
        this.executor = Executors.newFixedThreadPool(this.threadsNumber);
    }

    private void initSemaphore() {
        transactionsSemaphore = new Semaphore(this.threadsNumber * 3);
    }

    private static /* synthetic */ void lambda$insertQueriesInOneTransaction$36(GraknGraph graknGraph, InsertQuery q) {
        Void cfr_ignored_0 = (Void)q.withGraph(graknGraph).execute();
    }
}

