/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.engine.loader.TransactionState;
import ai.grakn.graql.InsertQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Loader {
    protected AtomicInteger enqueuedJobs;
    protected AtomicInteger loadingJobs;
    protected AtomicInteger finishedJobs;
    protected AtomicInteger errorJobs;
    protected Collection<InsertQuery> queries;
    protected int batchSize;
    protected int threadsNumber;
    final Logger LOG = LoggerFactory.getLogger(Loader.class);

    public Loader() {
        this.enqueuedJobs = new AtomicInteger();
        this.loadingJobs = new AtomicInteger();
        this.errorJobs = new AtomicInteger();
        this.finishedJobs = new AtomicInteger();
        this.queries = new HashSet<InsertQuery>();
    }

    protected abstract void sendQueriesToLoader(Collection<InsertQuery> var1);

    public abstract void waitToFinish();

    public void add(InsertQuery query) {
        this.queries.add(query);
        if (this.queries.size() >= this.batchSize) {
            this.sendQueriesToLoader(this.queries);
            this.queries.clear();
        }
    }

    public Loader setBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Loader setThreadsNumber(int number) {
        this.threadsNumber = number;
        return this;
    }

    public void flush() {
        if (this.queries.size() > 0) {
            this.sendQueriesToLoader(this.queries);
            this.queries.clear();
        }
    }

    public void printLoaderState() {
        this.LOG.info(Json.object().set(TransactionState.State.QUEUED.name(), (Object)this.enqueuedJobs.get()).set(TransactionState.State.LOADING.name(), (Object)this.loadingJobs.get()).set(TransactionState.State.ERROR.name(), (Object)this.errorJobs.get()).set(TransactionState.State.FINISHED.name(), (Object)this.finishedJobs.get()).toString());
    }

    protected void handleError(Exception e, int i) {
        this.LOG.error("Caught exception ", (Throwable)e);
        try {
            Thread.sleep((i + 2) * 1000);
        }
        catch (InterruptedException e1) {
            this.LOG.error("Caught exception ", (Throwable)e1);
        }
    }
}

