/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.engine.backgroundtasks.InMemoryTaskManager;
import ai.grakn.engine.loader.TransactionState;
import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.graql.QueryBuilder;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import mjson.Json;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTLoader {
    private final Logger LOG = LoggerFactory.getLogger(RESTLoader.class);
    private Cache cache;
    private static int repeatCommits;
    private static RESTLoader instance;
    private ExecutorService executor;
    private final Map<UUID, TransactionState> loaderState;
    private AtomicInteger enqueuedJobs;
    private AtomicInteger loadingJobs;
    private AtomicInteger finishedJobs;
    private AtomicLong lastJobFinished;
    private AtomicInteger errorJobs;

    public long getLastJobFinished() {
        return this.lastJobFinished.get();
    }

    public int getLoadingJobs() {
        return this.loadingJobs.get();
    }

    private RESTLoader() {
        ConfigProperties prop = ConfigProperties.getInstance();
        this.cache = Cache.getInstance();
        this.loaderState = new ConcurrentHashMap<UUID, TransactionState>();
        this.enqueuedJobs = new AtomicInteger();
        this.loadingJobs = new AtomicInteger();
        this.errorJobs = new AtomicInteger();
        this.finishedJobs = new AtomicInteger();
        this.lastJobFinished = new AtomicLong();
        repeatCommits = prop.getPropertyAsInt("loader.repeat-commits");
        int numberThreads = prop.getAvailableThreads();
        this.executor = Executors.newFixedThreadPool(numberThreads);
        this.startPeriodPostProcessingCheck();
    }

    public static synchronized RESTLoader getInstance() {
        if (instance == null) {
            instance = new RESTLoader();
        }
        return instance;
    }

    private void startPeriodPostProcessingCheck() {
        long postProcessingDelay = ConfigProperties.getInstance().getPropertyAsLong("backgroundTasks.post-processing-delay");
        Date runAt = new Date();
        runAt.setTime(runAt.getTime() + postProcessingDelay);
        InMemoryTaskManager.getInstance().scheduleTask(new PostProcessingTask(), this.getClass().getName(), runAt, postProcessingDelay, new JSONObject());
    }

    public String getLoaderState() {
        return Json.object().set(TransactionState.State.QUEUED.name(), (Object)this.enqueuedJobs.get()).set(TransactionState.State.LOADING.name(), (Object)this.loadingJobs.get()).set(TransactionState.State.ERROR.name(), (Object)this.errorJobs.get()).set(TransactionState.State.FINISHED.name(), (Object)this.finishedJobs.get()).toString();
    }

    public UUID addJob(String name, Json queryString) {
        UUID newUUID = UUID.randomUUID();
        this.loaderState.put(newUUID, new TransactionState(TransactionState.State.QUEUED));
        this.executor.submit(() -> this.loadData(name, queryString, newUUID));
        this.enqueuedJobs.incrementAndGet();
        return newUUID;
    }

    /*
     * Exception decompiling
     */
    public void loadData(String name, Json inserts, UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getStatus(UUID uuid) {
        return this.loaderState.get(uuid).toString();
    }

    private void handleError(Exception e, int i) {
        this.LOG.error("Caught exception while trying to commit a new transaction.", (Throwable)e);
        try {
            Thread.sleep((i + 2) * 1000);
        }
        catch (InterruptedException e1) {
            this.LOG.error("Caught exception ", (Throwable)e1);
        }
    }

    private static /* synthetic */ void lambda$loadData$1(QueryBuilder queryBuilder, String b) {
        queryBuilder.parse(b).execute();
    }

    static {
        instance = null;
    }
}

