/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class Cache {
    private final Map<String, Set<String>> castings = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> resources = new ConcurrentHashMap<String, Set<String>>();
    private final AtomicBoolean saveInProgress = new AtomicBoolean(false);
    private static Cache instance = null;

    public static synchronized Cache getInstance() {
        if (instance == null) {
            instance = new Cache();
        }
        return instance;
    }

    private Cache() {
    }

    public boolean isSaveInProgress() {
        return this.saveInProgress.get();
    }

    public Set<String> getKeyspaces() {
        HashSet<String> keyspaces = new HashSet<String>();
        keyspaces.addAll(this.castings.keySet());
        keyspaces.addAll(this.resources.keySet());
        return keyspaces;
    }

    public Set<String> getCastingJobs(String keyspace) {
        keyspace = keyspace.toLowerCase();
        return this.castings.computeIfAbsent(keyspace, key -> ConcurrentHashMap.newKeySet());
    }

    public void addJobCasting(String keyspace, Set<String> conceptIds) {
        this.getCastingJobs(keyspace).addAll(conceptIds);
    }

    public void deleteJobCasting(String keyspace, String conceptId) {
        this.getCastingJobs(keyspace).remove(conceptId);
    }

    public Set<String> getResourceJobs(String keyspace) {
        keyspace = keyspace.toLowerCase();
        return this.resources.computeIfAbsent(keyspace, key -> ConcurrentHashMap.newKeySet());
    }

    public void addJobResource(String keyspace, Set<String> conceptIds) {
        this.getResourceJobs(keyspace).addAll(conceptIds);
    }

    public void deleteJobResource(String keyspace, String conceptId) {
        this.getResourceJobs(keyspace).remove(conceptId);
    }
}

