/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.GraknGraph;
import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.util.ErrorMessage;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConceptFixer {
    private static final Logger LOG = LoggerFactory.getLogger(ConceptFixer.class);
    private static final int MAX_RETRY = 10;

    ConceptFixer() {
    }

    public static void checkCasting(Cache cache, GraknGraph graph, String castingId) {
        boolean notDone = true;
        int retry = 0;
        while (notDone) {
            try {
                if (((AbstractGraknGraph)graph).fixDuplicateCasting((Object)castingId)) {
                    graph.commit();
                }
                cache.deleteJobCasting(graph.getKeyspace(), castingId);
                notDone = false;
            }
            catch (Exception e) {
                LOG.error(ErrorMessage.POSTPROCESSING_ERROR.getMessage(new Object[]{"casting", e.getMessage()}), (Throwable)e);
                if (retry++ > 10) {
                    LOG.error(ErrorMessage.UNABLE_TO_ANALYSE_CONCEPT.getMessage(new Object[]{castingId, e.getMessage()}), (Throwable)e);
                    notDone = false;
                    continue;
                }
                ConceptFixer.performRetry(retry);
            }
        }
    }

    public static void checkResources(Cache cache, GraknGraph graph, Set<String> resourceIds) {
        boolean notDone = true;
        int retry = 0;
        while (notDone) {
            try {
                if (((AbstractGraknGraph)graph).fixDuplicateResources(resourceIds)) {
                    graph.commit();
                }
                resourceIds.forEach(resourceId -> cache.deleteJobResource(graph.getKeyspace(), (String)resourceId));
                notDone = false;
            }
            catch (Exception e) {
                LOG.error(ErrorMessage.POSTPROCESSING_ERROR.getMessage(new Object[]{"resource", e.getMessage()}), (Throwable)e);
                if (retry++ > 10) {
                    String message = "";
                    for (String resourceId2 : resourceIds) {
                        message = message + resourceId2;
                    }
                    LOG.error(ErrorMessage.UNABLE_TO_ANALYSE_CONCEPT.getMessage(new Object[]{message, e.getMessage()}), (Throwable)e);
                    notDone = false;
                    continue;
                }
                ConceptFixer.performRetry(retry);
            }
        }
    }

    private static int performRetry(int retry) {
        double seed = 1.0 + Math.random() * 5.0;
        double waitTime = (double)(++retry) * 2.0 + seed;
        LOG.error(ErrorMessage.BACK_OFF_RETRY.getMessage(new Object[]{waitTime}));
        try {
            Thread.sleep((long)Math.ceil(waitTime * 1000.0));
        }
        catch (InterruptedException e1) {
            LOG.error("Exception", (Throwable)e1);
        }
        return retry;
    }
}

