/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.engine.backgroundtasks.BackgroundTask;
import ai.grakn.engine.loader.RESTLoader;
import ai.grakn.engine.postprocessing.PostProcessing;
import ai.grakn.engine.util.ConfigProperties;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessingTask
implements BackgroundTask {
    private final Logger LOG = LoggerFactory.getLogger(PostProcessingTask.class);
    private static long timeLapse;
    private PostProcessing postProcessing;

    public PostProcessingTask() {
        timeLapse = ConfigProperties.getInstance().getPropertyAsLong("backgroundTasks.time-lapse");
        this.postProcessing = PostProcessing.getInstance();
    }

    @Override
    public void start(Consumer<String> saveCheckpoint, JSONObject configuration) {
        if (RESTLoader.getInstance().getLoadingJobs() != 0) {
            return;
        }
        long lastJob = RESTLoader.getInstance().getLastJobFinished();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastJob >= timeLapse) {
            this.postProcessing.run();
        }
    }

    @Override
    public void stop() {
        this.postProcessing.stop();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume(Consumer<String> saveCheckpoint, String lastCheckpoint) {
    }
}

