/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.session;

import ai.grakn.GraknGraph;
import ai.grakn.engine.session.GraqlSession;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graql.Printer;
import ai.grakn.graql.internal.printer.Printers;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mjson.Json;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class RemoteSession {
    private final Map<Session, GraqlSession> sessions = new HashMap<Session, GraqlSession>();
    private final Function<String, GraknGraph> getGraph;
    private final Logger LOG = LoggerFactory.getLogger(RemoteSession.class);
    private static final ImmutableMap<String, Printer> printers = ImmutableMap.of((Object)"graql", (Object)Printers.graql(), (Object)"json", (Object)Printers.json());

    public RemoteSession() {
        this(GraphFactory.getInstance()::getGraph);
    }

    public RemoteSession(Function<String, GraknGraph> getGraph) {
        this.getGraph = getGraph;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        String message = "Websocket closed, code: " + statusCode + ", reason: " + reason;
        if (statusCode == 1000 || statusCode == 1001) {
            this.LOG.debug(message);
        } else {
            this.LOG.error(message);
        }
        this.sessions.remove(session).close();
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        try {
            Json json = Json.read((String)message);
            switch (json.at("action").asString()) {
                case "init": {
                    this.startSession(session, json);
                    break;
                }
                case "query": {
                    this.sessions.get(session).receiveQuery(json);
                    break;
                }
                case "end": {
                    this.sessions.get(session).executeQuery();
                    break;
                }
                case "queryAbort": {
                    this.sessions.get(session).abortQuery();
                    break;
                }
                case "commit": {
                    this.sessions.get(session).commit();
                    break;
                }
                case "rollback": {
                    this.sessions.get(session).rollback();
                }
            }
        }
        catch (Throwable e) {
            this.LOG.error("Exception", e);
            throw e;
        }
    }

    private void startSession(Session session, Json json) {
        String keyspace = json.at("keyspace").asString();
        String outputFormat = json.at("outputFormat").asString();
        Printer printer = (Printer)printers.getOrDefault((Object)outputFormat, (Object)Printers.graql());
        GraqlSession graqlSession = new GraqlSession(session, () -> this.getGraph.apply(keyspace), printer);
        this.sessions.put(session, graqlSession);
    }
}

