/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.util;

import ai.grakn.util.ErrorMessage;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProperties {
    public static final String TEST_CONFIG_FILE = "../conf/test/tinker/grakn-engine.properties";
    public static final String DEFAULT_CONFIG_FILE = "../conf/main/grakn-engine.properties";
    public static final String DEFAULT_LOG_CONFIG_FILE = "../conf/main/logback.xml";
    public static final String GRAPH_CONFIG_PROPERTY = "graphdatabase.config";
    public static final String GRAPH_BATCH_CONFIG_PROPERTY = "graphdatabase.batch-config";
    public static final String GRAPH_COMPUTER_CONFIG_PROPERTY = "graphdatabase.computer";
    public static final String DEFAULT_GRAPH_NAME_PROPERTY = "graphdatabase.default-graph-name";
    public static final String BATCH_SIZE_PROPERTY = "blockingLoader.batch-size";
    public static final String NUM_THREADS_PROPERTY = "loader.threads";
    public static final String POLLING_FREQUENCY_PROPERTY = "loader.polling-frequency";
    public static final String SERVER_HOST_NAME = "server.host";
    public static final String SERVER_PORT_NUMBER = "server.port";
    public static final String HAL_DEGREE_PROPERTY = "halBuilder.degree";
    public static final String LOADER_REPEAT_COMMITS = "loader.repeat-commits";
    public static final String POSTPROCESSING_DELAY = "backgroundTasks.post-processing-delay";
    public static final String TIME_LAPSE = "backgroundTasks.time-lapse";
    public static final String STATIC_FILES_PATH = "server.static-file-dir";
    public static final String LOGGING_FILE_PATH = "logging.file";
    public static final String LOGGING_LEVEL = "logging.level";
    public static final String PROJECT_VERSION = "project.version";
    public static final String CURRENT_DIR_SYSTEM_PROPERTY = "grakn.dir";
    public static final String CONFIG_FILE_SYSTEM_PROPERTY = "grakn.conf";
    public static final String LOG_FILE_OUTPUT_SYSTEM_PROPERTY = "grakn.log.file";
    public static final String LOG_LEVEL_SYSTEM_PROPERTY = "grakn.log.level";
    public static final String LOG_FILE_CONFIG_SYSTEM_PROPERTY = "logback.configurationFile";
    public static final String SYSTEM_GRAPH_NAME = "graknSystem";
    public static final String SYSTEM_ONTOLOGY_FILE = "system.gql";
    private Logger LOG;
    private final int MAX_NUMBER_OF_THREADS = 120;
    private Properties prop;
    private static ConfigProperties instance = null;
    private String configFilePath = null;
    private int numOfThreads = -1;
    public static final String GRAKN_ASCII = "     ___  ___  ___  _  __ _  _     ___  ___     \n    / __|| _ \\/   \\| |/ /| \\| |   /   \\|_ _|    \n   | (_ ||   /| - || ' < | .` | _ | - | | |     \n    \\___||_|_\\|_|_||_|\\_\\|_|\\_|(_)|_|_||___|   \n\n Web Dashboard available at [%s]";

    public static synchronized ConfigProperties getInstance() {
        if (instance == null) {
            instance = new ConfigProperties();
        }
        return instance;
    }

    private ConfigProperties() {
        ConfigProperties.getProjectPath();
        this.prop = new Properties();
        try {
            this.prop.load(new FileInputStream(this.getConfigFilePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prop.put(PROJECT_VERSION, "0.7.0");
        this.initialiseLogger();
        this.computeThreadsNumber();
        this.LOG.info("Project directory in use: [" + ConfigProperties.getProjectPath() + "]");
        this.LOG.info("Configuration file in use: [" + this.configFilePath + "]");
        this.LOG.info("Number of threads set to [" + this.numOfThreads + "]");
    }

    private void setConfigFilePath() {
        String string = this.configFilePath = System.getProperty(CONFIG_FILE_SYSTEM_PROPERTY) != null ? System.getProperty(CONFIG_FILE_SYSTEM_PROPERTY) : DEFAULT_CONFIG_FILE;
        if (!Paths.get(this.configFilePath, new String[0]).isAbsolute()) {
            this.configFilePath = ConfigProperties.getProjectPath() + this.configFilePath;
        }
    }

    private void initialiseLogger() {
        if (System.getProperty(LOG_FILE_CONFIG_SYSTEM_PROPERTY) == null) {
            System.setProperty(LOG_FILE_CONFIG_SYSTEM_PROPERTY, ConfigProperties.getProjectPath() + DEFAULT_LOG_CONFIG_FILE);
        }
        System.setProperty(LOG_FILE_OUTPUT_SYSTEM_PROPERTY, this.getPath(LOGGING_FILE_PATH));
        this.setLogLevel();
        if (!new File(System.getProperty(LOG_FILE_CONFIG_SYSTEM_PROPERTY)).exists()) {
            LoggerFactory.getLogger(ConfigProperties.class).error(ErrorMessage.NO_LOG_CONFIG_FILE.getMessage(new Object[]{System.getProperty(LOG_FILE_CONFIG_SYSTEM_PROPERTY)}));
        } else {
            this.LOG = LoggerFactory.getLogger(ConfigProperties.class);
            this.LOG.info("Logging configuration file in use:[" + System.getProperty(LOG_FILE_CONFIG_SYSTEM_PROPERTY) + "]");
        }
    }

    private void setLogLevel() {
        if (System.getProperty(LOG_LEVEL_SYSTEM_PROPERTY) == null) {
            System.setProperty(LOG_LEVEL_SYSTEM_PROPERTY, this.prop.getProperty(LOGGING_LEVEL));
        }
    }

    private void computeThreadsNumber() {
        this.numOfThreads = Integer.parseInt(this.prop.getProperty(NUM_THREADS_PROPERTY));
        if (this.numOfThreads == 0) {
            this.numOfThreads = Runtime.getRuntime().availableProcessors();
        }
        if (this.numOfThreads > 120) {
            this.numOfThreads = 120;
        }
    }

    public String getLogFilePath() {
        return System.getProperty(LOG_FILE_OUTPUT_SYSTEM_PROPERTY);
    }

    public int getAvailableThreads() {
        if (this.numOfThreads == -1) {
            this.computeThreadsNumber();
        }
        return this.numOfThreads;
    }

    public String getPath(String path) {
        String propertyPath = this.prop.getProperty(path);
        if (Paths.get(propertyPath, new String[0]).isAbsolute()) {
            return propertyPath;
        }
        return ConfigProperties.getProjectPath() + propertyPath;
    }

    private static String getProjectPath() {
        if (System.getProperty(CURRENT_DIR_SYSTEM_PROPERTY) == null) {
            System.setProperty(CURRENT_DIR_SYSTEM_PROPERTY, System.getProperty("user.dir"));
        }
        return System.getProperty(CURRENT_DIR_SYSTEM_PROPERTY) + "/";
    }

    String getConfigFilePath() {
        if (this.configFilePath == null) {
            this.setConfigFilePath();
        }
        return this.configFilePath;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String getProperty(String property) {
        return this.prop.getProperty(property);
    }

    public int getPropertyAsInt(String property) {
        return Integer.parseInt(this.prop.getProperty(property));
    }

    public long getPropertyAsLong(String property) {
        return Long.parseLong(this.prop.getProperty(property));
    }
}

