/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.visualiser;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HALConceptData {
    private RepresentationFactory factory;
    private Representation halResource;
    private final String resourceLinkPrefix;
    private final String resourceLinkOntologyPrefix;
    private static final String ROOT_CONCEPT = "type";
    private static final String ISA_EDGE = "isa";
    private static final String SUB_EDGE = "sub";
    private static final String ONTOLOGY_LINK = "ontology";
    private static final String OUTBOUND_EDGE = "OUT";
    private static final String INBOUND_EDGE = "IN";
    private static final String ID_PROPERTY = "_id";
    private static final String TYPE_PROPERTY = "_type";
    private static final String BASETYPE_PROPERTY = "_baseType";
    private static final String DIRECTION_PROPERTY = "_direction";
    private static final String VALUE_PROPERTY = "value";
    private boolean embedType;
    private Set<String> typesInQuery = null;

    public HALConceptData(Concept concept, int separationDegree, boolean embedTypeParam, Set<String> typesInQuery) {
        this.embedType = embedTypeParam;
        this.typesInQuery = typesInQuery;
        this.resourceLinkPrefix = "/graph/concept/";
        this.resourceLinkOntologyPrefix = "/graph/concept/ontology/";
        this.factory = new StandardRepresentationFactory();
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId());
        this.handleConcept(this.halResource, concept, separationDegree);
    }

    private void handleConcept(Representation halResource, Concept concept, int separationDegree) {
        this.generateStateAndLinks(halResource, concept);
        if (this.embedType && concept.type() != null && (this.typesInQuery.contains(concept.type().getId()) || concept.type().superType() != null && this.typesInQuery.contains(concept.type().superType().getId()))) {
            this.embedType(halResource, concept);
        }
        if (concept.type() == null && this.typesInQuery.contains(ROOT_CONCEPT)) {
            this.embedType(halResource, concept);
        }
        if (concept.isType() && concept.asType().superType() != null) {
            this.embedSuperType(halResource, concept.asType());
        }
        if (concept.isRelation() && separationDegree == 0) {
            this.generateRelationEmbedded(halResource, concept.asRelation(), 1);
        }
        if (concept.isRule()) {
            this.generateRuleLHS(halResource, concept.asRule());
            this.generateRuleRHS(halResource, concept.asRule());
        }
        if (separationDegree == 0) {
            return;
        }
        if (concept.isEntity()) {
            this.generateEntityEmbedded(halResource, concept.asEntity(), separationDegree);
        }
        if (concept.isRelation()) {
            this.generateRelationEmbedded(halResource, concept.asRelation(), separationDegree);
        }
        if (concept.isResource()) {
            this.generateOwnerInstances(halResource, concept.asResource(), separationDegree);
        }
        if (concept.isType()) {
            this.generateTypeEmbedded(halResource, concept.asType(), separationDegree);
        }
    }

    private void generateRuleRHS(Representation halResource, Rule rule) {
        Representation RHS = this.factory.newRepresentation(this.resourceLinkPrefix + "RHS-" + rule.getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE).withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix).withProperty(ID_PROPERTY, (Object)("RHS-" + rule.getId())).withProperty(TYPE_PROPERTY, (Object)"RHS").withProperty(BASETYPE_PROPERTY, (Object)"resource-type").withProperty(VALUE_PROPERTY, (Object)rule.getRHS().admin().toString());
        halResource.withRepresentation("RHS", (ReadableRepresentation)RHS);
    }

    private void generateRuleLHS(Representation halResource, Rule rule) {
        Representation LHS = this.factory.newRepresentation(this.resourceLinkPrefix + "LHS-" + rule.getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE).withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix).withProperty(ID_PROPERTY, (Object)("LHS-" + rule.getId())).withProperty(TYPE_PROPERTY, (Object)"LHS").withProperty(BASETYPE_PROPERTY, (Object)"resource-type").withProperty(VALUE_PROPERTY, (Object)rule.getLHS().admin().asConjunction().getPatterns().stream().map(Object::toString).collect(Collectors.joining("; \n")));
        halResource.withRepresentation("LHS", (ReadableRepresentation)LHS);
    }

    private void generateOwnerInstances(Representation halResource, Resource conceptResource, int separationDegree) {
        RoleType roleType = (RoleType)conceptResource.type().playsRoles().iterator().next();
        conceptResource.ownerInstances().forEach(object -> {
            Instance currentInstance = (Instance)object;
            Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + currentInstance.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
            this.handleConcept(instanceResource, (Concept)currentInstance, separationDegree - 1);
            halResource.withRepresentation(roleType.getId(), (ReadableRepresentation)instanceResource);
        });
    }

    private void embedSuperType(Representation halResource, Type type) {
        Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + type.superType().getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
        this.generateStateAndLinks(HALType, (Concept)type.superType());
        halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)HALType);
    }

    private void embedType(Representation halResource, Concept concept) {
        if (concept.type() != null) {
            Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + concept.type().getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(HALType, (Concept)concept.type());
            halResource.withRepresentation(ISA_EDGE, (ReadableRepresentation)HALType);
        } else if (!concept.getId().equals(ROOT_CONCEPT)) {
            Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + ROOT_CONCEPT).withProperty(ID_PROPERTY, (Object)ROOT_CONCEPT).withProperty(TYPE_PROPERTY, (Object)ROOT_CONCEPT).withProperty(BASETYPE_PROPERTY, (Object)ROOT_CONCEPT).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE).withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix + concept.getId());
            halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)HALType);
        }
    }

    private void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix + concept.getId());
        if (concept.isInstance()) {
            resource.withProperty(ID_PROPERTY, (Object)concept.getId()).withProperty(TYPE_PROPERTY, (Object)concept.type().getId()).withProperty(BASETYPE_PROPERTY, (Object)concept.type().type().getId());
        } else {
            resource.withProperty(ID_PROPERTY, (Object)concept.getId()).withProperty(TYPE_PROPERTY, (Object)(concept.type() == null ? ROOT_CONCEPT : concept.type().getId())).withProperty(BASETYPE_PROPERTY, (Object)ROOT_CONCEPT);
        }
        if (concept.isResource()) {
            resource.withProperty(VALUE_PROPERTY, concept.asResource().getValue());
        }
        if (concept.isEntity()) {
            this.generateResources(resource, concept.asEntity().resources(new ResourceType[0]));
        }
        if (concept.isRelation()) {
            this.generateResources(resource, concept.asRelation().resources(new ResourceType[0]));
        }
    }

    private void generateResources(Representation resource, Collection<Resource<?>> resourcesCollection) {
        resourcesCollection.forEach(currentResource -> {
            Representation embeddedResource = this.factory.newRepresentation(this.resourceLinkPrefix + currentResource.getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(embeddedResource, (Concept)currentResource);
            resource.withRepresentation(currentResource.type().getId(), (ReadableRepresentation)embeddedResource);
        });
    }

    private void generateEntityEmbedded(Representation halResource, Entity entity, int separationDegree) {
        entity.relations(new RoleType[0]).parallelStream().forEach(rel -> {
            String rolePlayedByCurrentConcept = null;
            boolean isResource = false;
            for (Map.Entry entry : rel.rolePlayers().entrySet()) {
                if (entry.getValue() == null) continue;
                if (((Instance)entry.getValue()).isResource()) {
                    isResource = true;
                    continue;
                }
                if (!((Instance)entry.getValue()).getId().equals(entity.getId())) continue;
                rolePlayedByCurrentConcept = ((RoleType)entry.getKey()).getId();
            }
            if (!isResource) {
                this.attachRelation(halResource, (Concept)rel, rolePlayedByCurrentConcept, separationDegree);
            }
        });
    }

    private void attachRelation(Representation halResource, Concept rel, String role, int separationDegree) {
        Representation relationResource = this.factory.newRepresentation(this.resourceLinkPrefix + rel.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
        this.handleConcept(relationResource, rel, separationDegree - 1);
        halResource.withRepresentation(role, (ReadableRepresentation)relationResource);
    }

    private void generateRelationEmbedded(Representation halResource, Relation rel, int separationDegree) {
        rel.rolePlayers().forEach((roleType, instance) -> {
            if (instance != null) {
                Representation roleResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
                this.handleConcept(roleResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(roleType.getId(), (ReadableRepresentation)roleResource);
            }
        });
    }

    private void generateTypeEmbedded(Representation halResource, Type type, int separationDegree) {
        if (!type.getId().equals(ROOT_CONCEPT)) {
            type.instances().parallelStream().forEach(instance -> {
                if (instance.isType() && instance.asType().isImplicit().booleanValue()) {
                    return;
                }
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
                this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(ISA_EDGE, (ReadableRepresentation)instanceResource);
            });
        }
        type.subTypes().forEach(instance -> {
            if (!instance.getId().equals(type.getId())) {
                Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
                this.handleConcept(instanceResource, (Concept)instance, separationDegree - 1);
                halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)instanceResource);
            }
        });
    }

    public String render() {
        return this.halResource.toString("application/hal+json");
    }

    public Representation getRepresentation() {
        return this.halResource;
    }
}

