/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.visualiser;

import ai.grakn.concept.Concept;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import com.theoryinpractise.halbuilder.api.RepresentationFactory;
import com.theoryinpractise.halbuilder.standard.StandardRepresentationFactory;
import java.util.Collection;

public class HALConceptOntology {
    private RepresentationFactory factory = new StandardRepresentationFactory();
    private Representation halResource;
    private final String resourceLinkPrefix;
    private final String resourceLinkOntologyPrefix;
    private static final String ROOT_CONCEPT = "type";
    private static final String ISA_EDGE = "isa";
    private static final String SUB_EDGE = "sub";
    private static final String ONTOLOGY_LINK = "ontology";
    private static final String OUTBOUND_EDGE = "OUT";
    private static final String INBOUND_EDGE = "IN";
    private static final String HAS_ROLE_EDGE = "has-role";
    private static final String PLAYS_ROLE_EDGE = "plays-role";
    private static final String ID_PROPERTY = "_id";
    private static final String TYPE_PROPERTY = "_type";
    private static final String BASETYPE_PROPERTY = "_baseType";
    private static final String DIRECTION_PROPERTY = "_direction";
    private static final String VALUE_PROPERTY = "value";

    public HALConceptOntology(Concept concept) {
        this.resourceLinkPrefix = "/graph/concept/";
        this.resourceLinkOntologyPrefix = "/graph/concept/ontology/";
        this.halResource = this.factory.newRepresentation(this.resourceLinkPrefix + concept.getId());
        this.handleConceptOntology(this.halResource, concept);
    }

    private void generateStateAndLinks(Representation resource, Concept concept) {
        resource.withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix + concept.getId());
        if (concept.isInstance()) {
            resource.withProperty(ID_PROPERTY, (Object)concept.getId()).withProperty(TYPE_PROPERTY, (Object)concept.type().getId()).withProperty(BASETYPE_PROPERTY, (Object)concept.type().type().getId());
        } else {
            resource.withProperty(ID_PROPERTY, (Object)concept.getId()).withProperty(TYPE_PROPERTY, (Object)(concept.type() == null ? ROOT_CONCEPT : concept.type().getId())).withProperty(BASETYPE_PROPERTY, (Object)ROOT_CONCEPT);
        }
        if (concept.isResource()) {
            resource.withProperty(VALUE_PROPERTY, concept.asResource().getValue());
        }
    }

    private void embedType(Representation halResource, Concept concept) {
        if (concept.type() != null) {
            Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + concept.type().getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(HALType, (Concept)concept.type());
            halResource.withRepresentation(ISA_EDGE, (ReadableRepresentation)HALType);
        } else if (!concept.getId().equals(ROOT_CONCEPT)) {
            Representation HALType = this.factory.newRepresentation(this.resourceLinkPrefix + ROOT_CONCEPT).withProperty(ID_PROPERTY, (Object)ROOT_CONCEPT).withProperty(TYPE_PROPERTY, (Object)ROOT_CONCEPT).withProperty(BASETYPE_PROPERTY, (Object)ROOT_CONCEPT).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE).withLink(ONTOLOGY_LINK, this.resourceLinkOntologyPrefix + concept.getId());
            halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)HALType);
        }
    }

    private void handleConceptOntology(Representation halResource, Concept concept) {
        this.generateStateAndLinks(halResource, concept);
        this.embedType(halResource, concept);
        if (concept.isRelationType()) {
            this.relationTypeOntology(halResource, concept.asRelationType());
        } else if (concept.isRoleType()) {
            this.roleTypeOntology(halResource, concept.asRoleType());
        } else if (concept.isType()) {
            this.attachRolesPlayed(halResource, concept.asType().playsRoles());
        }
        if (concept.isType()) {
            concept.asType().subTypes().forEach(instance -> {
                if (!instance.getId().equals(concept.getId())) {
                    Representation instanceResource = this.factory.newRepresentation(this.resourceLinkPrefix + instance.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
                    this.generateStateAndLinks(instanceResource, (Concept)instance);
                    halResource.withRepresentation(SUB_EDGE, (ReadableRepresentation)instanceResource);
                }
            });
        }
    }

    private void roleTypeOntology(Representation halResource, RoleType roleType) {
        roleType.playedByTypes().forEach(type -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + type.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
            this.generateStateAndLinks(roleRepresentation, (Concept)type);
            halResource.withRepresentation(PLAYS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        });
        RelationType relType = roleType.relationType();
        Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + relType.getId()).withProperty(DIRECTION_PROPERTY, (Object)INBOUND_EDGE);
        this.generateStateAndLinks(roleRepresentation, (Concept)relType);
        halResource.withRepresentation(HAS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        this.attachRolesPlayed(halResource, roleType.playsRoles());
    }

    private void relationTypeOntology(Representation halResource, RelationType relationType) {
        relationType.hasRoles().forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            halResource.withRepresentation(HAS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        });
        this.attachRolesPlayed(halResource, relationType.playsRoles());
    }

    private void attachRolesPlayed(Representation halResource, Collection<RoleType> roles) {
        roles.forEach(role -> {
            Representation roleRepresentation = this.factory.newRepresentation(this.resourceLinkPrefix + role.getId()).withProperty(DIRECTION_PROPERTY, (Object)OUTBOUND_EDGE);
            this.generateStateAndLinks(roleRepresentation, (Concept)role);
            halResource.withRepresentation(PLAYS_ROLE_EDGE, (ReadableRepresentation)roleRepresentation);
        });
    }

    public String render() {
        return this.halResource.toString("application/hal+json");
    }
}

