/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.visualiser;

import ai.grakn.concept.Concept;
import ai.grakn.engine.controller.VisualiserController;
import ai.grakn.engine.visualiser.HALConceptData;
import ai.grakn.engine.visualiser.HALConceptOntology;
import ai.grakn.engine.visualiser.HALGeneratedRelation;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALConceptRepresentationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(VisualiserController.class);
    private static final int MATCH_QUERY_FIXED_DEGREE = 0;
    private static final String ASSERTION_URL = "/graph/match?query=match $x id '%s'; $y id '%s'; $r (%s$x, %s$y); select $r;";
    private static final String HAS_ROLE_EDGE = "EMPTY-GRAKN-ROLE";

    public static JSONArray renderHALArrayData(MatchQuery matchQuery, Collection<Map<String, Concept>> graqlResultsList) {
        HashMap<String, Collection<String>> linkedNodes = new HashMap<String, Collection<String>>();
        HashMap<String, String> roleTypes = new HashMap<String, String>();
        HALConceptRepresentationBuilder.computeLinkedNodesFromQuery(matchQuery, linkedNodes, roleTypes);
        Set<String> typesAskedInQuery = matchQuery.admin().getTypes().stream().map(Concept::getId).collect(Collectors.toSet());
        String relationType = matchQuery.admin().getTypes().stream().filter(Concept::isRelationType).findFirst().map(Concept::getId).orElse("");
        return HALConceptRepresentationBuilder.buildHALRepresentations(graqlResultsList, linkedNodes, typesAskedInQuery, relationType, roleTypes);
    }

    public static String renderHALConceptData(Concept concept, int separationDegree) {
        return new HALConceptData(concept, separationDegree, false, new HashSet<String>()).render();
    }

    public static String renderHALConceptOntology(Concept concept) {
        return new HALConceptOntology(concept).render();
    }

    private static JSONArray buildHALRepresentations(Collection<Map<String, Concept>> graqlResultsList, Map<String, Collection<String>> linkedNodes, Set<String> typesAskedInQuery, String relationType, Map<String, String> roleTypes) {
        JSONArray lines = new JSONArray();
        graqlResultsList.parallelStream().forEach(resultLine -> resultLine.entrySet().forEach(current -> {
            if (((Concept)current.getValue()).isType() && ((Concept)current.getValue()).asType().isImplicit().booleanValue()) {
                return;
            }
            LOG.trace("Building HAL resource for concept with id {}", (Object)((Concept)current.getValue()).getId());
            Representation currentHal = new HALConceptData((Concept)current.getValue(), 0, true, typesAskedInQuery).getRepresentation();
            HALConceptRepresentationBuilder.attachGeneratedRelation(currentHal, current, linkedNodes, resultLine, relationType, roleTypes);
            lines.put((Object)new JSONObject(currentHal.toString("application/hal+json")));
        }));
        return lines;
    }

    private static void attachGeneratedRelation(Representation currentHal, Map.Entry<String, Concept> current, Map<String, Collection<String>> linkedNodes, Map<String, Concept> resultLine, String relationType, Map<String, String> roleTypes) {
        if (linkedNodes.containsKey(current.getKey())) {
            linkedNodes.get(current.getKey()).forEach(varName -> {
                if (current.getValue() != null) {
                    String secondRole;
                    String firstRole;
                    String secondID;
                    String firstID;
                    Concept rolePlayer = (Concept)resultLine.get(varName);
                    String currentID = ((Concept)current.getValue()).getId();
                    if (currentID.compareTo(rolePlayer.getId()) > 0) {
                        firstID = currentID;
                        secondID = rolePlayer.getId();
                        firstRole = ((String)roleTypes.get(current.getKey())).equals(HAS_ROLE_EDGE) ? "" : (String)roleTypes.get(current.getKey()) + ":";
                        secondRole = ((String)roleTypes.get(varName)).equals(HAS_ROLE_EDGE) ? "" : (String)roleTypes.get(varName) + ":";
                    } else {
                        firstID = rolePlayer.getId();
                        secondID = currentID;
                        secondRole = ((String)roleTypes.get(current.getKey())).equals(HAS_ROLE_EDGE) ? "" : (String)roleTypes.get(current.getKey()) + ":";
                        firstRole = ((String)roleTypes.get(varName)).equals(HAS_ROLE_EDGE) ? "" : (String)roleTypes.get(varName) + ":";
                    }
                    String assertionID = String.format(ASSERTION_URL, firstID, secondID, firstRole, secondRole);
                    currentHal.withRepresentation((String)roleTypes.get(current.getKey()), (ReadableRepresentation)new HALGeneratedRelation().getNewGeneratedRelation(assertionID, relationType));
                }
            });
        }
    }

    private static Map<String, Collection<String>> computeLinkedNodesFromQuery(MatchQuery matchQuery, Map<String, Collection<String>> linkedNodes, Map<String, String> roleTypes) {
        matchQuery.admin().getPattern().getVars().forEach(var -> {
            List<String> rolePlayersInVar;
            if (var.getProperty(RelationProperty.class).isPresent() && (rolePlayersInVar = ((RelationProperty)var.getProperty(RelationProperty.class).get()).getRelationPlayers().map(x -> {
                roleTypes.put(x.getRolePlayer().getName(), x.getRoleType().isPresent() ? (String)((VarAdmin)x.getRoleType().get()).getId().get() : HAS_ROLE_EDGE);
                return x.getRolePlayer().getName();
            }).collect(Collectors.toList())).size() > 1) {
                rolePlayersInVar.forEach(rolePlayer -> {
                    linkedNodes.putIfAbsent((String)rolePlayer, new HashSet());
                    rolePlayersInVar.forEach(y -> {
                        if (!y.equals(rolePlayer)) {
                            ((Collection)linkedNodes.get(rolePlayer)).add(y);
                        }
                    });
                });
            }
        });
        return linkedNodes;
    }
}

