/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknGraph;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.factory.FactoryBuilder;

public class GraphFactory {
    private String graphConfig = ConfigProperties.getInstance().getPath("graphdatabase.config");
    private String graphBatchConfig = ConfigProperties.getInstance().getPath("graphdatabase.batch-config");
    private static GraphFactory instance = null;

    public static synchronized GraphFactory getInstance() {
        if (instance == null) {
            instance = new GraphFactory();
        }
        return instance;
    }

    private GraphFactory() {
    }

    public synchronized GraknGraph getGraph(String keyspace) {
        return FactoryBuilder.getFactory((String)keyspace, null, (String)this.graphConfig).getGraph(false);
    }

    public synchronized GraknGraph getGraphBatchLoading(String keyspace) {
        return FactoryBuilder.getFactory((String)keyspace, null, (String)this.graphBatchConfig).getGraph(true);
    }
}

