/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.GraknEngineServer;
import ai.grakn.engine.GraknEngineStatus;
import ai.grakn.engine.HttpHandler;
import ai.grakn.engine.data.RedisWrapper;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.JedisLockProvider;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.postprocessing.PostProcessor;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.engine.tasks.manager.redisqueue.RedisTaskManager;
import ai.grakn.engine.util.EngineID;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;
import spark.Service;

public class GraknCreator {
    protected final EngineID engineID = GraknCreator.engineId();
    protected final Service sparkService = GraknCreator.sparkService();
    protected final GraknEngineStatus graknEngineStatus = GraknCreator.graknEngineStatus();
    protected final MetricRegistry metricRegistry = GraknCreator.metricRegistry();
    protected final GraknConfig graknEngineConfig = GraknConfig.create();
    protected GraknEngineServer graknEngineServer;
    protected RedisWrapper redisWrapper;
    protected LockProvider lockProvider;
    protected EngineGraknTxFactory engineGraknTxFactory;
    protected TaskManager taskManager;

    protected static EngineID engineId() {
        return EngineID.me();
    }

    protected static Service sparkService() {
        return Service.ignite();
    }

    protected static GraknEngineStatus graknEngineStatus() {
        return new GraknEngineStatus();
    }

    protected static MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    public synchronized GraknEngineServer instantiateGraknEngineServer(Runtime runtime) {
        if (this.graknEngineServer == null) {
            RedisWrapper redisWrapper = this.instantiateRedis(this.graknEngineConfig);
            Pool<Jedis> jedisPool = redisWrapper.getJedisPool();
            LockProvider lockProvider = this.instantiateLock(jedisPool);
            EngineGraknTxFactory factory = this.instantiateGraknTxFactory(this.graknEngineConfig, lockProvider);
            PostProcessor postProcessor = this.postProcessor(this.metricRegistry, this.graknEngineConfig, factory, jedisPool, lockProvider);
            TaskManager taskManager = this.instantiateTaskManager(this.metricRegistry, this.graknEngineConfig, this.engineID, factory, jedisPool, postProcessor);
            HttpHandler httpHandler = new HttpHandler(this.graknEngineConfig, this.sparkService, factory, this.metricRegistry, this.graknEngineStatus, taskManager, postProcessor);
            this.graknEngineServer = new GraknEngineServer(this.graknEngineConfig, taskManager, factory, lockProvider, this.graknEngineStatus, redisWrapper, httpHandler, this.engineID);
            Thread thread = new Thread(this.graknEngineServer::close, "GraknEngineServer-shutdown");
            runtime.addShutdownHook(thread);
        }
        return this.graknEngineServer;
    }

    protected synchronized RedisWrapper instantiateRedis(GraknConfig config) {
        if (this.redisWrapper == null) {
            this.redisWrapper = this.redisWrapper(config);
        }
        return this.redisWrapper;
    }

    protected RedisWrapper redisWrapper(GraknConfig config) {
        List redisUrl = (List)config.getProperty(GraknConfigKey.REDIS_HOST);
        List sentinelUrl = (List)config.getProperty(GraknConfigKey.REDIS_SENTINEL_HOST);
        int poolSize = (Integer)config.getProperty(GraknConfigKey.REDIS_POOL_SIZE);
        boolean useSentinel = !sentinelUrl.isEmpty();
        RedisWrapper.Builder builder = RedisWrapper.builder().setUseSentinel(useSentinel).setPoolSize(poolSize).setURI(useSentinel ? sentinelUrl : redisUrl);
        if (useSentinel) {
            builder.setMasterName((String)config.getProperty(GraknConfigKey.REDIS_SENTINEL_MASTER));
        }
        return builder.build();
    }

    protected synchronized LockProvider instantiateLock(Pool<Jedis> jedisPool) {
        if (this.lockProvider == null) {
            this.lockProvider = this.lockProvider(jedisPool);
        }
        return this.lockProvider;
    }

    protected JedisLockProvider lockProvider(Pool<Jedis> jedisPool) {
        return new JedisLockProvider(jedisPool);
    }

    protected synchronized EngineGraknTxFactory instantiateGraknTxFactory(GraknConfig config, LockProvider lockProvider) {
        if (this.engineGraknTxFactory == null) {
            this.engineGraknTxFactory = GraknCreator.engineGraknTxFactory(config, lockProvider);
        }
        return this.engineGraknTxFactory;
    }

    protected static EngineGraknTxFactory engineGraknTxFactory(GraknConfig config, LockProvider lockProvider) {
        return EngineGraknTxFactory.create(lockProvider, config);
    }

    protected synchronized TaskManager instantiateTaskManager(MetricRegistry metricRegistry, GraknConfig config, EngineID engineId, EngineGraknTxFactory factory, Pool<Jedis> jedisPool, PostProcessor postProcessor) {
        if (this.taskManager == null) {
            this.taskManager = this.taskManager(config, factory, jedisPool, engineId, metricRegistry, postProcessor);
        }
        return this.taskManager;
    }

    protected PostProcessor postProcessor(MetricRegistry metricRegistry, GraknConfig config, EngineGraknTxFactory factory, Pool<Jedis> jedisPool, LockProvider lockProvider) {
        return PostProcessor.create(config, jedisPool, factory, lockProvider, metricRegistry);
    }

    TaskManager taskManager(GraknConfig config, EngineGraknTxFactory factory, Pool<Jedis> jedisPool, EngineID engineId, MetricRegistry metricRegistry, PostProcessor postProcessor) {
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "idle"}), (Metric)((Gauge)() -> jedisPool.getNumIdle()));
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "active"}), (Metric)((Gauge)() -> jedisPool.getNumActive()));
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "waiters"}), (Metric)((Gauge)() -> jedisPool.getNumWaiters()));
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "borrow_wait_time_ms", "max"}), (Metric)((Gauge)() -> jedisPool.getMaxBorrowWaitTimeMillis()));
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "borrow_wait_time_ms", "mean"}), (Metric)((Gauge)() -> jedisPool.getMeanBorrowWaitTimeMillis()));
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"System", "gc"}), (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"System", "threads"}), (Metric)new CachedThreadStatesGaugeSet(15L, TimeUnit.SECONDS));
        metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"System", "memory"}), (Metric)new MemoryUsageGaugeSet());
        int consumers = (Integer)config.getProperty(GraknConfigKey.QUEUE_CONSUMERS);
        return new RedisTaskManager(engineId, config, jedisPool, consumers, factory, metricRegistry, postProcessor);
    }

    @VisibleForTesting
    public synchronized GraknEngineServer cleanGraknEngineServer(GraknConfig config) {
        return this.cleanGraknEngineServer(config, this.redisWrapper(config));
    }

    @VisibleForTesting
    public synchronized GraknEngineServer cleanGraknEngineServer(GraknConfig config, RedisWrapper redisWrapper) {
        Pool<Jedis> jedisPool = redisWrapper.getJedisPool();
        JedisLockProvider lockProvider = this.lockProvider(jedisPool);
        EngineGraknTxFactory factory = GraknCreator.engineGraknTxFactory(config, lockProvider);
        MetricRegistry metricRegistry = GraknCreator.metricRegistry();
        EngineID engineID = GraknCreator.engineId();
        PostProcessor postProcessor = this.postProcessor(metricRegistry, config, factory, jedisPool, lockProvider);
        TaskManager taskManager = this.taskManager(config, factory, jedisPool, engineID, metricRegistry, postProcessor);
        GraknEngineStatus graknEngineStatus = GraknCreator.graknEngineStatus();
        HttpHandler httpHandler = new HttpHandler(config, GraknCreator.sparkService(), factory, metricRegistry, graknEngineStatus, taskManager, postProcessor);
        return new GraknEngineServer(config, taskManager, factory, lockProvider, graknEngineStatus, redisWrapper, httpHandler, engineID);
    }
}

