/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.GraknEngineStatus;
import ai.grakn.engine.HttpHandler;
import ai.grakn.engine.data.RedisWrapper;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.engine.util.EngineID;
import ai.grakn.util.ErrorMessage;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class GraknEngineServer
implements AutoCloseable {
    private static final String REDIS_VERSION_KEY = "info:version";
    private static final String LOAD_SYSTEM_SCHEMA_LOCK_NAME = "load-system-schema";
    private static final Logger LOG = LoggerFactory.getLogger(GraknEngineServer.class);
    private final GraknConfig prop;
    private final TaskManager taskManager;
    private final EngineGraknTxFactory factory;
    private final LockProvider lockProvider;
    private final GraknEngineStatus graknEngineStatus;
    private final RedisWrapper redisWrapper;
    private final HttpHandler httpHandler;
    private final EngineID engineId;

    public GraknEngineServer(GraknConfig prop, TaskManager taskManager, EngineGraknTxFactory factory, LockProvider lockProvider, GraknEngineStatus graknEngineStatus, RedisWrapper redisWrapper, HttpHandler httpHandler, EngineID engineId) {
        this.prop = prop;
        this.graknEngineStatus = graknEngineStatus;
        this.redisWrapper = redisWrapper;
        this.lockProvider = lockProvider;
        this.factory = factory;
        this.taskManager = taskManager;
        this.httpHandler = httpHandler;
        this.engineId = engineId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.redisWrapper.testConnection();
        LOG.info("Starting task manager {}", (Object)this.taskManager.getClass().getCanonicalName());
        this.taskManager.start();
        Stopwatch timer = Stopwatch.createStarted();
        this.logStartMessage((String)this.prop.getProperty(GraknConfigKey.SERVER_HOST_NAME), (Integer)this.prop.getProperty(GraknConfigKey.SERVER_PORT));
        GraknEngineServer graknEngineServer = this;
        synchronized (graknEngineServer) {
            this.checkVersion();
            this.lockAndInitializeSystemSchema();
            this.httpHandler.startHTTP();
        }
        this.graknEngineStatus.setReady(true);
        LOG.info("Grakn started in {}", (Object)timer.stop());
    }

    private void checkVersion() {
        Jedis jedis = (Jedis)this.redisWrapper.getJedisPool().getResource();
        String storedVersion = jedis.get(REDIS_VERSION_KEY);
        if (storedVersion == null) {
            jedis.set(REDIS_VERSION_KEY, "1.0.0");
        } else if (!storedVersion.equals("1.0.0")) {
            LOG.warn(ErrorMessage.VERSION_MISMATCH.getMessage(new Object[]{"1.0.0", storedVersion}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GraknEngineServer graknEngineServer = this;
        synchronized (graknEngineServer) {
            try {
                this.taskManager.close();
            }
            catch (Exception e) {
                LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
            this.httpHandler.stopHTTP();
            this.redisWrapper.close();
        }
    }

    private void lockAndInitializeSystemSchema() {
        try {
            Lock lock = this.lockProvider.getLock(LOAD_SYSTEM_SCHEMA_LOCK_NAME);
            if (lock.tryLock(60L, TimeUnit.SECONDS)) {
                this.loadAndUnlock(lock);
            } else {
                LOG.info("{} found system schema lock already acquired by other engine", (Object)this.engineId);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{} was interrupted while initializing system schema", (Object)this.engineId);
        }
    }

    private void loadAndUnlock(Lock lock) {
        try {
            LOG.info("{} is checking the system schema", (Object)this.engineId);
            this.factory.systemKeyspace().loadSystemSchema();
        }
        finally {
            lock.unlock();
        }
    }

    private void logStartMessage(String host, int port) {
        String address = "http://" + host + ":" + port;
        LOG.info("\n==================================================");
        LOG.info("\n" + String.format(GraknConfig.GRAKN_ASCII, address));
        LOG.info("\n==================================================");
    }

    public EngineGraknTxFactory factory() {
        return this.factory;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public GraknEngineStatus getGraknEngineStatus() {
        return this.graknEngineStatus;
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    public LockProvider lockProvider() {
        return this.lockProvider;
    }
}

