/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.GraknEngineStatus;
import ai.grakn.engine.controller.CommitLogController;
import ai.grakn.engine.controller.ConceptController;
import ai.grakn.engine.controller.GraqlController;
import ai.grakn.engine.controller.SystemController;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.postprocessing.PostProcessor;
import ai.grakn.engine.printer.JacksonPrinter;
import ai.grakn.engine.session.RemoteSession;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.exception.GraknServerException;
import com.codahale.metrics.MetricRegistry;
import java.nio.file.Path;
import mjson.Json;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Response;
import spark.Service;

public class HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHandler.class);
    private final GraknConfig prop;
    private final Service spark;
    private final EngineGraknTxFactory factory;
    private final MetricRegistry metricRegistry;
    private final GraknEngineStatus graknEngineStatus;
    private final TaskManager taskManager;
    private final PostProcessor postProcessor;

    public HttpHandler(GraknConfig prop, Service spark, EngineGraknTxFactory factory, MetricRegistry metricRegistry, GraknEngineStatus graknEngineStatus, TaskManager taskManager, PostProcessor postProcessor) {
        this.prop = prop;
        this.spark = spark;
        this.factory = factory;
        this.metricRegistry = metricRegistry;
        this.graknEngineStatus = graknEngineStatus;
        this.taskManager = taskManager;
        this.postProcessor = postProcessor;
    }

    public void startHTTP() {
        HttpHandler.configureSpark(this.spark, this.prop);
        this.startCollaborators();
        this.spark.awaitInitialization();
    }

    protected void startCollaborators() {
        RemoteSession graqlWebSocket = RemoteSession.create();
        this.spark.webSocket("/shell/remote", (Object)graqlWebSocket);
        JacksonPrinter printer = JacksonPrinter.create();
        new GraqlController(this.factory, this.spark, this.taskManager, this.postProcessor, printer, this.metricRegistry);
        new ConceptController(this.factory, this.spark, this.metricRegistry);
        new SystemController(this.spark, this.prop, this.factory.systemKeyspace(), this.graknEngineStatus, this.metricRegistry);
        new CommitLogController(this.spark, this.taskManager, this.postProcessor);
    }

    public static void configureSpark(Service spark, GraknConfig prop) {
        HttpHandler.configureSpark(spark, (String)prop.getProperty(GraknConfigKey.SERVER_HOST_NAME), (Integer)prop.getProperty(GraknConfigKey.SERVER_PORT), prop.getPath(GraknConfigKey.STATIC_FILES_PATH), (Integer)prop.getProperty(GraknConfigKey.WEBSERVER_THREADS));
    }

    public static void configureSpark(Service spark, String hostName, int port, Path staticFolder, int maxThreads) {
        spark.ipAddress(hostName);
        spark.port(port);
        spark.staticFiles.externalLocation(staticFolder.toString());
        spark.threadPool(maxThreads);
        spark.webSocketIdleTimeoutMillis(3600000);
        spark.exception(GraknServerException.class, (e, req, res) -> {
            assert (e instanceof GraknServerException);
            HttpHandler.handleGraknServerError((GraknServerException)e, res);
        });
        spark.exception(Exception.class, (e, req, res) -> HttpHandler.handleInternalError(e, res));
    }

    public void stopHTTP() {
        this.spark.stop();
        boolean running = true;
        while (running) {
            try {
                this.spark.port();
            }
            catch (IllegalStateException e) {
                LOG.debug("Spark server has been stopped");
                running = false;
            }
        }
    }

    private static void handleGraknServerError(GraknServerException exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(exception.getStatus());
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }

    private static void handleInternalError(Exception exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(500);
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }
}

