/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.engine.SystemKeyspace;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.InvalidKBException;
import com.google.common.base.Stopwatch;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspaceImpl
implements SystemKeyspace {
    private static final Label KEYSPACE_ENTITY = Label.of((String)"keyspace");
    private static final Logger LOG = LoggerFactory.getLogger(SystemKeyspace.class);
    private final Set<Keyspace> existingKeyspaces;
    private final EngineGraknTxFactory factory;
    private final LockProvider lockProvider;

    private SystemKeyspaceImpl(EngineGraknTxFactory factory, LockProvider lockProvider, boolean loadSystemSchema) {
        this.factory = factory;
        this.existingKeyspaces = ConcurrentHashMap.newKeySet();
        this.lockProvider = lockProvider;
        if (loadSystemSchema) {
            this.loadSystemSchema();
        }
    }

    public static SystemKeyspace create(EngineGraknTxFactory factory, LockProvider lockProvider, boolean loadSystemSchema) {
        return new SystemKeyspaceImpl(factory, lockProvider, loadSystemSchema);
    }

    public void openKeyspace(Keyspace keyspace) {
        if (this.existingKeyspaces.contains(keyspace)) {
            return;
        }
        if (this.containsKeyspace(keyspace)) {
            this.existingKeyspaces.add(keyspace);
            return;
        }
        Lock lock = this.lockProvider.getLock(SystemKeyspaceImpl.getLockingKey(keyspace));
        lock.lock();
        try {
            this.factory.initialiseNewKeyspace(keyspace);
            this.logNewKeyspace(keyspace);
        }
        finally {
            lock.unlock();
        }
    }

    private void logNewKeyspace(Keyspace keyspace) {
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)graph.getSchemaConcept(KEYSPACE_RESOURCE);
            if (keyspaceName == null) {
                throw GraknBackendException.initializationException((Keyspace)keyspace);
            }
            Attribute attribute = keyspaceName.putAttribute((Object)keyspace.getValue());
            if (attribute.owner() == null) {
                ((EntityType)graph.getSchemaConcept(KEYSPACE_ENTITY)).addEntity().attribute(attribute);
            }
            graph.admin().commitSubmitNoLogs();
        }
        catch (InvalidKBException e) {
            throw new RuntimeException("Could not add keyspace [" + keyspace + "] to system graph", e);
        }
    }

    private static String getLockingKey(Keyspace keyspace) {
        return "/creating-new-keyspace-lock/" + keyspace.getValue();
    }

    public boolean containsKeyspace(Keyspace keyspace) {
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.READ);){
            boolean bl = graph.getAttributeType(KEYSPACE_RESOURCE.getValue()).getAttribute((Object)keyspace) != null;
            return bl;
        }
    }

    public boolean deleteKeyspace(Keyspace keyspace) {
        if (keyspace.equals(SYSTEM_KB_KEYSPACE)) {
            return false;
        }
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)graph.getSchemaConcept(KEYSPACE_RESOURCE);
            Attribute attribute = keyspaceName.getAttribute((Object)keyspace.getValue());
            if (attribute == null) {
                boolean bl = false;
                return bl;
            }
            Thing thing = attribute.owner();
            if (thing != null) {
                thing.delete();
            }
            attribute.delete();
            this.existingKeyspaces.remove(keyspace);
            graph.admin().commitSubmitNoLogs();
        }
        return true;
    }

    public Set<Keyspace> keyspaces() {
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)graph.getSchemaConcept(KEYSPACE_RESOURCE);
            Set<Keyspace> set = ((EntityType)graph.getSchemaConcept(KEYSPACE_ENTITY)).instances().flatMap(keyspace -> keyspace.attributes(new AttributeType[]{keyspaceName})).map(name -> (String)name.getValue()).map(Keyspace::of).collect(Collectors.toSet());
            return set;
        }
    }

    public void loadSystemSchema() {
        Stopwatch timer = Stopwatch.createStarted();
        try (GraknTx tx = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            if (tx.getSchemaConcept(KEYSPACE_ENTITY) != null) {
                return;
            }
            LOG.info("Loading schema");
            this.loadSystemSchema(tx);
            tx.admin().commitSubmitNoLogs();
            LOG.info("Loaded system schema to system keyspace. Took: {}", (Object)timer.stop());
        }
        catch (Exception e) {
            LOG.error("Error while loading system schema in {}. The error was: {}", new Object[]{timer.stop(), e.getMessage(), e});
            throw e;
        }
    }

    private void loadSystemSchema(GraknTx tx) {
        AttributeType keyspaceName = tx.putAttributeType("keyspace-name", AttributeType.DataType.STRING);
        tx.putEntityType("keyspace").key(keyspaceName);
    }
}

