/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.Keyspace;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.postprocessing.PostProcessor;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.kb.log.CommitLog;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import spark.Request;
import spark.Service;

public class CommitLogController {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final TaskManager manager;
    private final PostProcessor postProcessor;

    public CommitLogController(Service spark, TaskManager manager, PostProcessor postProcessor) {
        this.manager = manager;
        this.postProcessor = postProcessor;
        spark.post("/kb/:keyspace/commit_log", (req, res) -> this.submitConcepts(req));
    }

    @POST
    @Path(value="/kb/{keyspace}/commit_log")
    private String submitConcepts(Request req) throws IOException {
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(req, "keyspace"));
        CommitLog commitLog = (CommitLog)mapper.readValue(req.body(), CommitLog.class);
        CommitLog commitLogPP = CommitLog.create((Keyspace)keyspace, Collections.emptyMap(), (Map)commitLog.attributes());
        TaskState postProcessingTaskState = PostProcessingTask.createTask(this.getClass());
        TaskConfiguration postProcessingTaskConfiguration = PostProcessingTask.createConfig(commitLogPP);
        CompletableFuture.allOf(CompletableFuture.runAsync(() -> this.postProcessor.updateCounts(keyspace, commitLog)), CompletableFuture.runAsync(() -> this.manager.addTask(postProcessingTaskState, postProcessingTaskConfiguration))).join();
        return "";
    }
}

