/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknTx;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.engine.Jacksonisable;
import ai.grakn.engine.controller.response.ConceptBuilder;
import ai.grakn.engine.controller.response.EmbeddedAttribute;
import ai.grakn.engine.controller.response.Link;
import ai.grakn.engine.controller.response.RolePlayer;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import spark.Request;
import spark.Response;
import spark.Service;

public class ConceptController {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private EngineGraknTxFactory factory;
    private Timer conceptIdGetTimer;
    private Timer labelGetTimer;
    private Timer instancesGetTimer;

    public ConceptController(EngineGraknTxFactory factory, Service spark, MetricRegistry metricRegistry) {
        this.factory = factory;
        this.conceptIdGetTimer = metricRegistry.timer(MetricRegistry.name(ConceptController.class, (String[])new String[]{"concept-by-identifier"}));
        this.labelGetTimer = metricRegistry.timer(MetricRegistry.name(ConceptController.class, (String[])new String[]{"concept-by-label"}));
        this.instancesGetTimer = metricRegistry.timer(MetricRegistry.name(ConceptController.class, (String[])new String[]{"instances-of-type"}));
        spark.get("/kb/:keyspace/concept/:id", this::getConceptById);
        spark.get("/kb/:keyspace/type/:label", this::getSchemaByLabel);
        spark.get("/kb/:keyspace/rule/:label", this::getSchemaByLabel);
        spark.get("/kb/:keyspace/role/:label", this::getSchemaByLabel);
        spark.get("/kb/:keyspace/type", this::getTypes);
        spark.get("/kb/:keyspace/rule", this::getRules);
        spark.get("/kb/:keyspace/role", this::getRoles);
        spark.get("/kb/:keyspace/concept/:id/attributes", this::getAttributes);
        spark.get("/kb/:keyspace/concept/:id/keys", this::getKeys);
        spark.get("/kb/:keyspace/concept/:id/relationships", this::getRelationships);
        spark.get("/kb/:keyspace/type/:label/instances", this::getTypeInstances);
        spark.get("/kb/:keyspace/type/:label/plays", this::getTypePlays);
        spark.get("/kb/:keyspace/type/:label/attributes", this::getTypeAttributes);
        spark.get("/kb/:keyspace/type/:label/keys", this::getTypeKeys);
        spark.get("/kb/:keyspace/type/:label/subs", this::getSchemaConceptSubs);
        spark.get("/kb/:keyspace/role/:label/subs", this::getSchemaConceptSubs);
        spark.get("/kb/:keyspace/rule/:label/subs", this::getSchemaConceptSubs);
    }

    private String getTypeAttributes(Request request, Response response) throws JsonProcessingException {
        Function<Type, Stream> collector = type -> type.attributes().map(ConceptBuilder::build);
        return this.getConceptCollection(request, response, ConceptController.buildTypeGetter(request), collector);
    }

    private String getTypeKeys(Request request, Response response) throws JsonProcessingException {
        Function<Type, Stream> collector = type -> type.keys().map(ConceptBuilder::build);
        return this.getConceptCollection(request, response, ConceptController.buildTypeGetter(request), collector);
    }

    private String getTypePlays(Request request, Response response) throws JsonProcessingException {
        Function<Type, Stream> collector = type -> type.plays().map(ConceptBuilder::build);
        return this.getConceptCollection(request, response, ConceptController.buildTypeGetter(request), collector);
    }

    private String getRelationships(Request request, Response response) throws JsonProcessingException {
        Function<Thing, Stream> collector = thing -> thing.plays().flatMap(role -> {
            Link roleWrapper = Link.create((SchemaConcept)role);
            return thing.relationships(new Role[]{role}).map(relationship -> {
                Link relationshipWrapper = Link.create((Thing)relationship);
                return RolePlayer.create(roleWrapper, relationshipWrapper);
            });
        });
        return this.getConceptCollection(request, response, ConceptController.buildThingGetter(request), collector);
    }

    private String getKeys(Request request, Response response) throws JsonProcessingException {
        return this.getAttributes(request, response, thing -> thing.keys(new AttributeType[0]));
    }

    private String getAttributes(Request request, Response response) throws JsonProcessingException {
        return this.getAttributes(request, response, thing -> thing.attributes(new AttributeType[0]));
    }

    private String getAttributes(Request request, Response response, Function<Thing, Stream<Attribute<?>>> attributeFetcher) throws JsonProcessingException {
        int offset = this.getOffset(request);
        int limit = this.getLimit(request);
        Function<Thing, Stream> collector = thing -> ((Stream)attributeFetcher.apply((Thing)thing)).skip(offset).limit(limit).map(EmbeddedAttribute::create);
        return this.getConceptCollection(request, response, ConceptController.buildThingGetter(request), collector);
    }

    /*
     * Exception decompiling
     */
    private <X extends Concept> String getConceptCollection(Request request, Response response, Function<GraknTx, X> getter, Function<X, Stream<Jacksonisable>> collector) throws JsonProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getSchemaConceptSubs(Request request, Response response) throws JsonProcessingException {
        Function<SchemaConcept, Stream> collector = schema -> schema.subs().map(ConceptBuilder::build);
        return this.getConceptCollection(request, response, ConceptController.buildSchemaConceptGetter(request), collector);
    }

    /*
     * Exception decompiling
     */
    private String getTypeInstances(Request request, Response response) throws JsonProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getOffset(Request request) {
        return this.getIntegerQueryParameter(request, "offset", 0);
    }

    private int getLimit(Request request) {
        return this.getIntegerQueryParameter(request, "limit", 100);
    }

    private int getIntegerQueryParameter(Request request, String parameter, int defaultValue) {
        Optional<String> value = Requests.queryParameter(request, parameter);
        return value.map(Integer::parseInt).orElse(defaultValue);
    }

    private String getSchemaByLabel(Request request, Response response) throws JsonProcessingException {
        Requests.validateRequest(request, "*/*");
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(request, "keyspace"));
        Label label = Label.of((String)Requests.mandatoryPathParameter(request, ":label"));
        return this.getConcept(response, keyspace, tx -> tx.getSchemaConcept(label));
    }

    private String getConceptById(Request request, Response response) throws JsonProcessingException {
        Requests.validateRequest(request, "*/*");
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(request, "keyspace"));
        ConceptId conceptId = ConceptId.of((String)Requests.mandatoryPathParameter(request, ":id"));
        return this.getConcept(response, keyspace, tx -> tx.getConcept(conceptId));
    }

    /*
     * Exception decompiling
     */
    private String getConcept(Response response, Keyspace keyspace, Function<GraknTx, Concept> getter) throws JsonProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getTypes(Request request, Response response) throws JsonProcessingException {
        return this.getConcepts(request, response, tx -> tx.admin().getMetaConcept().subs());
    }

    private String getRules(Request request, Response response) throws JsonProcessingException {
        return this.getConcepts(request, response, tx -> tx.admin().getMetaRule().subs());
    }

    private String getRoles(Request request, Response response) throws JsonProcessingException {
        return this.getConcepts(request, response, tx -> tx.admin().getMetaRole().subs());
    }

    /*
     * Exception decompiling
     */
    private String getConcepts(Request request, Response response, Function<GraknTx, Stream<? extends Concept>> getter) throws JsonProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Function<GraknTx, SchemaConcept> buildSchemaConceptGetter(Request request) {
        Label label = Label.of((String)Requests.mandatoryPathParameter(request, ":label"));
        return tx -> tx.getSchemaConcept(label);
    }

    private static Function<GraknTx, Type> buildTypeGetter(Request request) {
        Label label = Label.of((String)Requests.mandatoryPathParameter(request, ":label"));
        return tx -> tx.getType(label);
    }

    private static Function<GraknTx, Thing> buildThingGetter(Request request) {
        ConceptId conceptId = ConceptId.of((String)Requests.mandatoryPathParameter(request, ":id"));
        return tx -> {
            Concept concept = tx.getConcept(conceptId);
            if (concept == null || !concept.isThing()) {
                return null;
            }
            return concept.asThing();
        };
    }
}

