/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.AttributeType;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.postprocessing.PostProcessor;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.exception.TemporaryWriteException;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryParser;
import ai.grakn.graql.internal.printer.Printers;
import ai.grakn.kb.log.CommitLog;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import mjson.Json;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class GraqlController {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(GraqlController.class);
    private static final RetryLogger retryLogger = new RetryLogger();
    private static final int MAX_RETRY = 10;
    private final Printer printer;
    private final EngineGraknTxFactory factory;
    private final TaskManager taskManager;
    private final PostProcessor postProcessor;
    private final Timer executeGraql;
    private final Timer executeExplanation;

    public GraqlController(EngineGraknTxFactory factory, Service spark, TaskManager taskManager, PostProcessor postProcessor, Printer printer, MetricRegistry metricRegistry) {
        this.factory = factory;
        this.taskManager = taskManager;
        this.postProcessor = postProcessor;
        this.printer = printer;
        this.executeGraql = metricRegistry.timer(MetricRegistry.name(GraqlController.class, (String[])new String[]{"execute-graql"}));
        this.executeExplanation = metricRegistry.timer(MetricRegistry.name(GraqlController.class, (String[])new String[]{"execute-explanation"}));
        spark.post("/kb/:keyspace/graql", this::executeGraql);
        spark.get("/kb/:keyspace/explain", this::explainGraql);
        spark.exception(GraqlQueryException.class, (e, req, res) -> GraqlController.handleError(400, e, res));
        spark.exception(GraqlSyntaxException.class, (e, req, res) -> GraqlController.handleError(400, e, res));
        spark.exception(GraknTxOperationException.class, (e, req, res) -> GraqlController.handleError(422, e, res));
        spark.exception(InvalidKBException.class, (e, req, res) -> GraqlController.handleError(422, e, res));
    }

    @GET
    @Path(value="/kb/{keyspace}/explain")
    private String explainGraql(Request request, Response response) throws RetryException, ExecutionException {
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(request, "keyspace"));
        String queryString = Requests.mandatoryQueryParameter(request, "query");
        response.status(200);
        return this.executeFunctionWithRetrying(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @POST
    @Path(value="/kb/{keyspace}/graql")
    private String executeGraql(Request request, Response response) throws RetryException, ExecutionException {
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(request, "keyspace"));
        String queryString = Requests.mandatoryBody(request);
        Optional<Boolean> infer = Requests.queryParameter(request, "infer").map(Boolean::parseBoolean);
        boolean multiQuery = Boolean.parseBoolean(Requests.queryParameter(request, "multi").orElse("false"));
        Optional<Boolean> defineAllVars = Requests.queryParameter(request, "defineAllVars").map(Boolean::parseBoolean);
        boolean skipSerialisation = Boolean.parseBoolean(Requests.queryParameter(request, "loading").orElse("false"));
        GraknTxType txType = Requests.queryParameter(request, "txType").map(String::toUpperCase).map(GraknTxType::valueOf).orElse(GraknTxType.WRITE);
        String acceptType = "application/text".equals(Requests.getAcceptType(request)) ? "application/text" : "application/json";
        response.type("application/json");
        LOG.debug("Executing graql query: {}", (Object)StringUtils.abbreviate((String)queryString, (int)100));
        LOG.trace("Full query: {}", (Object)queryString);
        return this.executeFunctionWithRetrying(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private String executeFunctionWithRetrying(Callable<String> callable) throws RetryException, ExecutionException {
        try {
            Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(TemporaryWriteException.class).withRetryListener((RetryListener)retryLogger).withWaitStrategy(WaitStrategies.exponentialWait((long)100L, (long)5L, (TimeUnit)TimeUnit.MINUTES)).withStopStrategy(StopStrategies.stopAfterAttempt((int)10)).build();
            return (String)retryer.call(callable);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
    }

    private static void handleError(int status, Exception exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(status);
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }

    private String executeQuery(GraknTx tx, String queryString, String acceptType, boolean multi, boolean skipSerialisation, QueryParser parser) throws JsonProcessingException {
        String formatted;
        Printer printer = this.printer;
        if ("application/text".equals(acceptType)) {
            printer = Printers.graql((boolean)false, (AttributeType[])new AttributeType[0]);
        }
        boolean commitQuery = true;
        if (multi) {
            Stream query = parser.parseList(queryString);
            List collectedResults = query.map(this::executeAndMonitor).collect(Collectors.toList());
            formatted = skipSerialisation ? mapper.writeValueAsString((Object)new Object[collectedResults.size()]) : printer.graqlString(collectedResults);
        } else {
            Query query = parser.parseQuery(queryString);
            formatted = skipSerialisation ? "" : printer.graqlString(this.executeAndMonitor(query));
            boolean bl = commitQuery = !query.isReadOnly();
        }
        if (commitQuery) {
            GraqlController.commitAndSubmitPPTask(tx, this.postProcessor, this.taskManager);
        }
        return formatted;
    }

    private static void commitAndSubmitPPTask(GraknTx graph, PostProcessor postProcessor, TaskManager taskSubmitter) {
        Optional result = graph.admin().commitSubmitNoLogs();
        if (result.isPresent()) {
            CommitLog logs = (CommitLog)result.get();
            System.out.println("Adding task to manager . . . ");
            taskSubmitter.addTask(PostProcessingTask.createTask(GraqlController.class), PostProcessingTask.createConfig(logs));
            System.out.println("Updating counts . . . ");
            postProcessor.updateCounts(graph.keyspace(), logs);
        }
    }

    private Object executeAndMonitor(Query<?> query) {
        return query.execute();
    }

    private static class RetryLogger
    implements RetryListener {
        private RetryLogger() {
        }

        public <V> void onRetry(Attempt<V> attempt) {
            if (attempt.hasException()) {
                LOG.warn("Retrying transaction after {" + attempt.getAttemptNumber() + "} attempts due to exception {" + attempt.getExceptionCause().getMessage() + "}");
            }
        }
    }
}

