/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.response;

import ai.grakn.engine.controller.response.Attribute;
import ai.grakn.engine.controller.response.AttributeType;
import ai.grakn.engine.controller.response.Concept;
import ai.grakn.engine.controller.response.EmbeddedSchemaConcept;
import ai.grakn.engine.controller.response.Entity;
import ai.grakn.engine.controller.response.EntityType;
import ai.grakn.engine.controller.response.Link;
import ai.grakn.engine.controller.response.MetaConcept;
import ai.grakn.engine.controller.response.Relationship;
import ai.grakn.engine.controller.response.RelationshipType;
import ai.grakn.engine.controller.response.Role;
import ai.grakn.engine.controller.response.RolePlayer;
import ai.grakn.engine.controller.response.Rule;
import ai.grakn.engine.controller.response.SchemaConcept;
import ai.grakn.engine.controller.response.Thing;
import ai.grakn.engine.controller.response.Things;
import ai.grakn.engine.controller.response.Type;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.internal.reasoner.utils.conversion.ConceptConverter;
import ai.grakn.util.Schema;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ConceptBuilder {
    public static <X extends Concept> X build(ai.grakn.concept.Concept concept) {
        Concept response;
        if (concept.isSchemaConcept()) {
            response = ConceptBuilder.buildSchemaConcept(concept.asSchemaConcept());
        } else if (concept.isThing()) {
            response = ConceptBuilder.buildThing(concept.asThing());
        } else {
            throw GraknBackendException.convertingUnknownConcept((ai.grakn.concept.Concept)concept);
        }
        return (X)response;
    }

    public static Things buildThings(ai.grakn.concept.Type type, int offset, int limit) {
        Link selfLink = Link.createInstanceLink(type);
        Link next = Link.createInstanceLink(type, offset + limit, limit);
        int previousIndex = offset - limit;
        if (previousIndex < 0) {
            previousIndex = 0;
        }
        Link previous = Link.createInstanceLink(type, previousIndex, limit);
        Set<Thing> things = type.instances().skip(offset).limit(limit).map(ConceptBuilder::buildThing).collect(Collectors.toSet());
        return Things.create(selfLink, things, next, previous);
    }

    private static Thing buildThing(ai.grakn.concept.Thing thing) {
        Link selfLink = Link.create(thing);
        EmbeddedSchemaConcept type = EmbeddedSchemaConcept.create((ai.grakn.concept.SchemaConcept)thing.type());
        Link attributes = Link.createAttributesLink(thing);
        Link keys = Link.createKeysLink(thing);
        Link relationships = Link.createRelationshipsLink(thing);
        String explanation = null;
        if (thing.isInferred()) {
            explanation = Graql.match((Pattern[])new Pattern[]{ConceptConverter.toPattern((ai.grakn.concept.Concept)thing)}).get().toString();
        }
        if (thing.isAttribute()) {
            return ConceptBuilder.buildAttribute(thing.asAttribute(), selfLink, type, attributes, keys, relationships, explanation);
        }
        if (thing.isRelationship()) {
            return ConceptBuilder.buildRelationship(thing.asRelationship(), selfLink, type, attributes, keys, relationships, explanation);
        }
        if (thing.isEntity()) {
            return ConceptBuilder.buildEntity(thing.asEntity(), selfLink, type, attributes, keys, relationships, explanation);
        }
        throw GraknBackendException.convertingUnknownConcept((ai.grakn.concept.Concept)thing);
    }

    private static SchemaConcept buildSchemaConcept(ai.grakn.concept.SchemaConcept schemaConcept) {
        Link selfLink = Link.create(schemaConcept);
        EmbeddedSchemaConcept sup = null;
        if (schemaConcept.sup() != null) {
            sup = EmbeddedSchemaConcept.create(schemaConcept.sup());
        }
        Link subs = Link.createSubsLink(schemaConcept);
        if (schemaConcept.isRole()) {
            return ConceptBuilder.buildRole(schemaConcept.asRole(), selfLink, sup, subs);
        }
        if (schemaConcept.isRule()) {
            return ConceptBuilder.buildRule(schemaConcept.asRule(), selfLink, sup, subs);
        }
        return ConceptBuilder.buildType(schemaConcept.asType(), selfLink, sup, subs);
    }

    private static Entity buildEntity(ai.grakn.concept.Entity entity, Link selfLink, EmbeddedSchemaConcept type, Link attributes, Link keys, Link relationships, String explanation) {
        return Entity.create(entity.getId(), selfLink, type, attributes, keys, relationships, entity.isInferred(), explanation);
    }

    private static Attribute buildAttribute(ai.grakn.concept.Attribute attribute, Link selfLink, EmbeddedSchemaConcept type, Link attributes, Link keys, Link relationships, String explanation) {
        return Attribute.create(attribute.getId(), selfLink, type, attributes, keys, relationships, attribute.isInferred(), explanation, attribute.type().getDataType().getName(), attribute.getValue().toString());
    }

    private static Relationship buildRelationship(ai.grakn.concept.Relationship relationship, Link selfLink, EmbeddedSchemaConcept type, Link attributes, Link keys, Link relationships, String explanation) {
        HashSet<RolePlayer> roleplayers = new HashSet<RolePlayer>();
        relationship.allRolePlayers().forEach((role, things) -> {
            Link roleLink = Link.create((ai.grakn.concept.SchemaConcept)role);
            things.forEach(thing -> roleplayers.add(RolePlayer.create(roleLink, Link.create(thing))));
        });
        return Relationship.create(relationship.getId(), selfLink, type, attributes, keys, relationships, relationship.isInferred(), explanation, roleplayers);
    }

    private static Type buildType(ai.grakn.concept.Type type, Link selfLink, EmbeddedSchemaConcept sup, Link subs) {
        Link plays = Link.createPlaysLink(type);
        Link attributes = Link.createAttributesLink(type);
        Link keys = Link.createKeysLink(type);
        Link instances = Link.createInstancesLink(type);
        if (Schema.MetaSchema.THING.getLabel().equals(type.getLabel())) {
            return MetaConcept.create(type.getId(), selfLink, type.getLabel(), sup, subs, plays, attributes, keys, instances);
        }
        if (type.isAttributeType()) {
            return ConceptBuilder.buildAttributeType(type.asAttributeType(), selfLink, sup, subs, plays, attributes, keys, instances);
        }
        if (type.isEntityType()) {
            return ConceptBuilder.buildEntityType(type.asEntityType(), selfLink, sup, subs, plays, attributes, keys, instances);
        }
        if (type.isRelationshipType()) {
            return ConceptBuilder.buildRelationshipType(type.asRelationshipType(), selfLink, sup, subs, plays, attributes, keys, instances);
        }
        throw GraknBackendException.convertingUnknownConcept((ai.grakn.concept.Concept)type);
    }

    private static Role buildRole(ai.grakn.concept.Role role, Link selfLink, EmbeddedSchemaConcept sup, Link subs) {
        Set<Link> relationships = role.relationshipTypes().map(Link::create).collect(Collectors.toSet());
        Set<Link> roleplayers = role.playedByTypes().map(Link::create).collect(Collectors.toSet());
        return Role.create(role.getId(), selfLink, role.getLabel(), role.isImplicit(), sup, subs, relationships, roleplayers);
    }

    private static Rule buildRule(ai.grakn.concept.Rule rule, Link selfLink, EmbeddedSchemaConcept sup, Link subs) {
        String when = null;
        if (rule.getWhen() != null) {
            when = rule.getWhen().toString();
        }
        String then = null;
        if (rule.getThen() != null) {
            then = rule.getThen().toString();
        }
        return Rule.create(rule.getId(), selfLink, rule.getLabel(), rule.isImplicit(), sup, subs, when, then);
    }

    private static AttributeType buildAttributeType(ai.grakn.concept.AttributeType attributeType, Link selfLink, EmbeddedSchemaConcept sup, Link subs, Link plays, Link attributes, Link keys, Link instances) {
        String dataType = null;
        if (attributeType.getDataType() != null) {
            dataType = attributeType.getDataType().getName();
        }
        return AttributeType.create(attributeType.getId(), selfLink, attributeType.getLabel(), attributeType.isImplicit(), sup, subs, attributeType.isAbstract(), plays, attributes, keys, instances, dataType, attributeType.getRegex());
    }

    private static EntityType buildEntityType(ai.grakn.concept.EntityType entityType, Link selfLink, EmbeddedSchemaConcept sup, Link subs, Link plays, Link attributes, Link keys, Link instances) {
        return EntityType.create(entityType.getId(), selfLink, entityType.getLabel(), entityType.isImplicit(), sup, subs, entityType.isAbstract(), plays, attributes, keys, instances);
    }

    private static RelationshipType buildRelationshipType(ai.grakn.concept.RelationshipType relationshipType, Link selfLink, EmbeddedSchemaConcept sup, Link subs, Link plays, Link attributes, Link keys, Link instances) {
        Set<Link> relates = relationshipType.relates().map(Link::create).collect(Collectors.toSet());
        return RelationshipType.create(relationshipType.getId(), selfLink, relationshipType.getLabel(), relationshipType.isImplicit(), sup, subs, relationshipType.isAbstract(), plays, attributes, keys, instances, relates);
    }
}

