/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.util;

import ai.grakn.exception.GraknServerException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import mjson.Json;
import spark.Request;

public class Requests {
    public static String mandatoryQueryParameter(Request request, String parameter) {
        return (String)Requests.mandatoryQueryParameter((String p) -> Requests.queryParameter(request, p), parameter);
    }

    public static <T> T mandatoryQueryParameter(Function<String, Optional<T>> extractParameterFunction, String parameter) {
        return extractParameterFunction.apply(parameter).orElseThrow(() -> GraknServerException.requestMissingParameters((String)parameter));
    }

    public static Optional<String> queryParameter(Request request, String parameter) {
        return Optional.ofNullable(request.queryParams(parameter));
    }

    public static String mandatoryBody(Request request) {
        return Optional.ofNullable(request.body()).filter(s -> !s.isEmpty()).orElseThrow(GraknServerException::requestMissingBody);
    }

    public static String mandatoryPathParameter(Request request, String parameter) {
        String parameterValue = Optional.ofNullable(request.params(parameter)).orElseThrow(() -> GraknServerException.requestMissingParameters((String)parameter));
        return parameterValue;
    }

    public static Json extractJsonField(Json json, String ... fieldPath) {
        Json currentField = json;
        for (String field : fieldPath) {
            Json tmp = currentField.at(field);
            if (tmp == null) {
                throw GraknServerException.requestMissingBodyParameters((String)field);
            }
            currentField = tmp;
        }
        return currentField;
    }

    public static void validateRequest(Request request, String ... contentTypes) {
        String acceptType = Requests.getAcceptType(request);
        if (!Arrays.asList(contentTypes).contains(acceptType)) {
            throw GraknServerException.unsupportedContentType((String)acceptType);
        }
    }

    public static String getAcceptType(Request request) {
        String header = request.headers("Accept");
        return header == null ? "" : request.headers("Accept").split(",")[0];
    }
}

