/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.factory;

import ai.grakn.GraknConfigKey;
import ai.grakn.GraknSession;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.SystemKeyspace;
import ai.grakn.engine.SystemKeyspaceImpl;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.factory.GraknSessionImpl;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class EngineGraknTxFactory {
    private final GraknConfig engineConfig;
    private final String engineURI;
    private final SystemKeyspace systemKeyspace;
    private final Map<Keyspace, GraknSession> openedSessions = new HashMap<Keyspace, GraknSession>();

    @VisibleForTesting
    public static EngineGraknTxFactory createAndLoadSystemSchema(LockProvider lockProvider, GraknConfig engineConfig) {
        return new EngineGraknTxFactory(engineConfig, lockProvider, true);
    }

    public static EngineGraknTxFactory create(LockProvider lockProvider, GraknConfig engineConfig) {
        return new EngineGraknTxFactory(engineConfig, lockProvider, false);
    }

    private EngineGraknTxFactory(GraknConfig engineConfig, LockProvider lockProvider, boolean loadSchema) {
        this.engineConfig = engineConfig;
        this.engineURI = (String)engineConfig.getProperty(GraknConfigKey.SERVER_HOST_NAME) + ":" + engineConfig.getProperty(GraknConfigKey.SERVER_PORT);
        this.systemKeyspace = SystemKeyspaceImpl.create(this, lockProvider, loadSchema);
    }

    @VisibleForTesting
    public synchronized void refreshConnections() {
        FactoryBuilder.refresh();
    }

    public GraknTx tx(String keyspace, GraknTxType type) {
        return this.tx(Keyspace.of((String)keyspace), type);
    }

    public GraknTx tx(Keyspace keyspace, GraknTxType type) {
        if (!keyspace.equals(SystemKeyspace.SYSTEM_KB_KEYSPACE)) {
            this.systemKeyspace.openKeyspace(keyspace);
        }
        return this.session(keyspace).open(type);
    }

    private GraknSession session(Keyspace keyspace) {
        if (!this.openedSessions.containsKey(keyspace)) {
            this.openedSessions.put(keyspace, (GraknSession)GraknSessionImpl.createEngineSession((Keyspace)keyspace, (String)this.engineURI, (GraknConfig)this.engineConfig));
        }
        return this.openedSessions.get(keyspace);
    }

    public void initialiseNewKeyspace(Keyspace keyspace) {
        this.session(keyspace).open(GraknTxType.WRITE).close();
    }

    public GraknConfig config() {
        return this.engineConfig;
    }

    public SystemKeyspace systemKeyspace() {
        return this.systemKeyspace;
    }
}

