/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.grakn_pid;

import ai.grakn.engine.grakn_pid.PidFileAlreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GraknPid {
    public static final Path GRAKN_PID_FILE_PATH = Paths.get(File.separator, "tmp", "grakn.pid");
    private final long pid;

    public GraknPid(long pid) {
        this.pid = pid;
    }

    public void createPidFile_deleteOnExit() {
        this.attemptToWritePidFile(this.pid, GRAKN_PID_FILE_PATH);
        this.deletePidFileOnExit();
    }

    private void deletePidFileOnExit() {
        GRAKN_PID_FILE_PATH.toFile().deleteOnExit();
    }

    private void attemptToWritePidFile(long pid, Path pidFilePath) {
        if (!pidFilePath.toFile().exists()) {
            String pidString = Long.toString(pid);
            try {
                Files.write(pidFilePath, pidString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new PidFileAlreadyExistsException(pidFilePath);
        }
    }
}

