/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.lock;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class JedisLock
implements Lock {
    private static final long TIMEOUT_MS = 10000L;
    private final String lockName;
    private String internalLockName;
    private int expireMsecs = 60000;
    private boolean locked = false;
    private Pool<Jedis> jedis;
    private Lock lock = new ReentrantLock();

    public JedisLock(Pool<Jedis> jedis, String internalLockName) {
        Preconditions.checkNotNull(jedis, (Object)"JedisPool used in lock cannot be null");
        Preconditions.checkArgument((internalLockName != null && !internalLockName.isEmpty() ? 1 : 0) != 0, (Object)"Lock name not valid");
        this.jedis = jedis;
        this.lockName = internalLockName;
        this.internalLockName = "lock:" + internalLockName;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        try (Jedis r = (Jedis)this.jedis.getResource();){
            this.acquire(r, 10000L);
        }
    }

    @Override
    public boolean tryLock() {
        try (Jedis r = (Jedis)this.jedis.getResource();){
            boolean bl = this.tryOnce(r);
            return bl;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull((Object)((Object)unit));
        long timeout = unit.convert(time, TimeUnit.MILLISECONDS);
        try (Jedis r = (Jedis)this.jedis.getResource();){
            boolean bl = this.acquire(r, timeout);
            return bl;
        }
    }

    @Override
    public void unlock() {
        try (Jedis r = (Jedis)this.jedis.getResource();){
            this.release(r);
        }
    }

    @Override
    public Condition newCondition() {
        throw new RuntimeException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquire(Jedis jedis, long timeout) throws InterruptedException {
        while (timeout >= 0L) {
            this.lock.lock();
            try {
                if (this.tryOnce(jedis)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
            timeout -= 100L;
            Thread.sleep(100L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryOnce(Jedis jedis) {
        long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
        String expiresStr = String.valueOf(expires);
        this.lock.lock();
        try {
            if (jedis.setnx(this.internalLockName, expiresStr) == 1L) {
                this.locked = true;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        String currentValueStr = jedis.get(this.internalLockName);
        if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis()) {
            this.lock.lock();
            try {
                String oldValueStr = jedis.getSet(this.internalLockName, expiresStr);
                if (oldValueStr != null && oldValueStr.equals(currentValueStr)) {
                    this.locked = true;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    private void release(Jedis jedis) {
        this.lock.lock();
        try {
            if (this.locked) {
                jedis.del(this.internalLockName);
                this.locked = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getLockName() {
        return this.lockName;
    }
}

