/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.module;

import ai.grakn.engine.module.GraknModuleException;
import ai.grakn.engine.module.GraknModuleHelper;
import ai.grakn.graknmodule.GraknModule;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.JarPluginManager;
import ro.fortsoft.pf4j.PluginManager;

public class GraknModuleManager {
    private static final String MODULE_DIR = "./modules";
    private static final Logger LOG = LoggerFactory.getLogger(GraknModuleManager.class);
    private static PluginManager pf4jPluginManager = new JarPluginManager();

    public static void initialise() {
        String moduleDirAbsolute = Paths.get(MODULE_DIR, new String[0]).toAbsolutePath().toString();
        LOG.info("Scanning Grakn modules directory at '{}'", (Object)moduleDirAbsolute);
        try {
            Stream<Path> folders = GraknModuleHelper.listFolders(Paths.get(MODULE_DIR, new String[0]));
            Stream pf4jPluginIds = folders.flatMap(GraknModuleManager::scanModuleDir);
            pf4jPluginIds.forEach(GraknModuleManager::startPf4JPlugin);
        }
        catch (RuntimeException e) {
            throw GraknModuleException.exception("Unable to scan module directory at '" + moduleDirAbsolute + "'", e);
        }
    }

    public static List<GraknModule> getGraknModules() {
        try {
            List modules = pf4jPluginManager.getExtensions(GraknModule.class);
            LOG.info("Number of Grakn module(s) found: {}", (Object)modules.size());
            for (GraknModule module : modules) {
                LOG.info("Module '{}' loaded", (Object)module.getGraknModuleName());
            }
            return modules;
        }
        catch (RuntimeException e) {
            throw GraknModuleException.exception("Unable to scan module directory", e);
        }
    }

    private static Stream<String> scanModuleDir(Path moduleDir) {
        LOG.info("Scanning '{}' directory for a module", (Object)moduleDir.getFileName());
        Stream<String> pluginIds = GraknModuleHelper.listJarFiles(moduleDir).map(moduleJar -> {
            LOG.info("Found '{}'", (Object)moduleJar.getFileName());
            try {
                return pf4jPluginManager.loadPlugin(moduleJar);
            }
            catch (RuntimeException e) {
                throw GraknModuleException.exception("Unable to load module '" + moduleJar + "'", e);
            }
        });
        return pluginIds;
    }

    private static void startPf4JPlugin(String pf4jPluginId) {
        LOG.info("Starting module '{}'", (Object)pf4jPluginId);
        try {
            pf4jPluginManager.startPlugin(pf4jPluginId);
        }
        catch (RuntimeException e) {
            throw GraknModuleException.exception("Unable to start module '" + pf4jPluginId + "'", e);
        }
    }
}

