/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.GraknConfigKey;
import ai.grakn.GraknTx;
import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.postprocessing.GraknTxMutators;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.kb.log.CommitLog;
import ai.grakn.util.Schema;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessingTask
extends BackgroundTask {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(PostProcessingTask.class);
    private static final String JOB_FINISHED = "Post processing Job [{}] completed for indeces and ids: [{}]";

    @Override
    public boolean start() {
        try (Timer.Context context = this.metricRegistry().timer(MetricRegistry.name(PostProcessingTask.class, (String[])new String[]{"execution"})).time();){
            CommitLog commitLog = PostProcessingTask.getPostProcessingCommitLog(this.configuration());
            commitLog.attributes().forEach((conceptIndex, conceptIds) -> {
                Timer.Context contextSingle = this.metricRegistry().timer(MetricRegistry.name(PostProcessingTask.class, (String[])new String[]{"execution-single"})).time();
                try {
                    Keyspace keyspace = commitLog.keyspace();
                    int maxRetry = (Integer)this.engineConfiguration().getProperty(GraknConfigKey.LOADER_REPEAT_COMMITS);
                    GraknTxMutators.runMutationWithRetry(this.factory(), keyspace, maxRetry, graph -> this.postProcessor().mergeDuplicateConcepts((GraknTx)graph, (String)conceptIndex, (Set<ConceptId>)conceptIds));
                }
                finally {
                    contextSingle.stop();
                }
            });
            LOG.debug(JOB_FINISHED, (Object)Schema.BaseType.ATTRIBUTE.name(), (Object)commitLog.attributes());
            boolean bl = true;
            return bl;
        }
    }

    private static CommitLog getPostProcessingCommitLog(TaskConfiguration configuration) {
        try {
            return (CommitLog)mapper.readValue(configuration.configuration(), CommitLog.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TaskState createTask(Class creator) {
        return TaskState.of(PostProcessingTask.class, creator.getName());
    }

    public static TaskConfiguration createConfig(CommitLog commitLog) {
        try {
            return TaskConfiguration.of(mapper.writeValueAsString((Object)commitLog));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

