/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.printer;

import ai.grakn.concept.Concept;
import ai.grakn.engine.controller.response.ConceptBuilder;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JacksonPrinter
implements Printer<Object> {
    private static ObjectMapper mapper = new ObjectMapper();

    public static JacksonPrinter create() {
        return new JacksonPrinter();
    }

    public String build(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error during serialising {%s}", object), e);
        }
    }

    public Object graqlString(boolean inner, Concept concept) {
        return ConceptBuilder.build(concept);
    }

    public Object graqlString(boolean inner, Answer answer) {
        return ai.grakn.engine.controller.response.Answer.create(answer);
    }

    public Object graqlString(boolean inner, boolean bool) {
        return bool;
    }

    public Object graqlStringDefault(boolean inner, Object object) {
        return object;
    }

    public Object graqlString(boolean inner, Map map) {
        Stream entries = map.entrySet().stream();
        return entries.collect(Collectors.toMap(entry -> this.graqlString(inner, entry.getKey()), entry -> this.graqlString(inner, entry.getKey())));
    }

    public Object graqlString(boolean inner, Collection collection) {
        return collection.stream().map(object -> this.graqlString(inner, object)).collect(Collectors.toList());
    }

    public Object graqlString(boolean inner, Optional optional) {
        if (optional.isPresent()) {
            return this.graqlString(inner, optional.get());
        }
        return null;
    }
}

