/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.session;

import ai.grakn.Grakn;
import ai.grakn.GraknSession;
import ai.grakn.engine.session.GraqlSession;
import ai.grakn.util.SimpleURI;
import java.util.HashMap;
import java.util.Map;
import mjson.Json;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSession
extends WebSocketAdapter {
    private final Map<Session, GraqlSession> sessions = new HashMap<Session, GraqlSession>();
    private final Logger LOG = LoggerFactory.getLogger(RemoteSession.class);

    public static RemoteSession create() {
        return new RemoteSession();
    }

    public void onWebSocketClose(int statusCode, String reason) {
        String message = "Websocket closed, code: " + statusCode + ", reason: " + reason;
        if (statusCode == 1000 || statusCode == 1001) {
            this.LOG.debug(message);
        } else {
            this.LOG.error(message);
        }
        this.sessions.remove(this.getSession()).close();
    }

    public void onWebSocketText(String message) {
        try {
            this.LOG.debug("Received message: " + message);
            Json json = Json.read((String)message);
            if (json.is("action", (Object)"init")) {
                this.startSession(json);
            } else {
                this.sessions.get(this.getSession()).handleMessage(json);
            }
        }
        catch (Throwable e) {
            this.LOG.error("Exception", (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            throw e;
        }
    }

    private void startSession(Json json) {
        String keyspace = json.at("keyspace").asString();
        String outputFormat = json.at("outputFormat").asString();
        boolean infer = json.at("infer").asBoolean();
        GraknSession factory = Grakn.session((SimpleURI)Grakn.DEFAULT_URI, (String)keyspace);
        GraqlSession graqlSession = new GraqlSession(this.getSession(), factory, outputFormat, infer);
        this.sessions.put(this.getSession(), graqlSession);
    }
}

