/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks;

import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.postprocessing.PostProcessor;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public abstract class BackgroundTask {
    @Nullable
    private TaskConfiguration configuration = null;
    @Nullable
    private GraknConfig engineConfig = null;
    @Nullable
    private EngineGraknTxFactory factory = null;
    @Nullable
    private MetricRegistry metricRegistry = null;
    @Nullable
    private PostProcessor postProcessor = null;

    public final void initialize(TaskConfiguration configuration, GraknConfig engineConfig, EngineGraknTxFactory factory, MetricRegistry metricRegistry, PostProcessor postProcessor) {
        this.configuration = configuration;
        this.engineConfig = engineConfig;
        this.metricRegistry = metricRegistry;
        this.factory = factory;
        this.postProcessor = postProcessor;
    }

    public abstract boolean start();

    public boolean stop() {
        throw new UnsupportedOperationException(this.getClass().getName() + " task cannot be stopped while in progress");
    }

    public final TaskConfiguration configuration() {
        return BackgroundTask.defaultNullCheck(this.configuration);
    }

    public final GraknConfig engineConfiguration() {
        return BackgroundTask.defaultNullCheck(this.engineConfig);
    }

    public final EngineGraknTxFactory factory() {
        return BackgroundTask.defaultNullCheck(this.factory);
    }

    public final MetricRegistry metricRegistry() {
        return BackgroundTask.defaultNullCheck(this.metricRegistry);
    }

    public final PostProcessor postProcessor() {
        return BackgroundTask.defaultNullCheck(this.postProcessor);
    }

    private static <X> X defaultNullCheck(X someThing) {
        Preconditions.checkNotNull(someThing, (Object)String.format("BackgroundTask#initialise must be called before retrieving {%s}", someThing.getClass().getSimpleName()));
        return someThing;
    }
}

