/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.util.EngineID;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Instant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskState
implements Serializable {
    private static final long serialVersionUID = -7301340972479426653L;
    private final String taskId;
    private TaskStatus status;
    private Instant statusChangeTime;
    private final String taskClassName;
    private final String creator;
    private EngineID engineID;
    private String stackTrace;
    private String exception;

    public static TaskState of(Class<?> taskClass, String creator) {
        return new TaskState(taskClass, creator, TaskId.generate());
    }

    public static TaskState of(TaskId id) {
        return new TaskState(null, null, id);
    }

    public static TaskState of(TaskId id, TaskStatus taskStatus) {
        return new TaskState(null, null, id, taskStatus);
    }

    @JsonCreator
    public TaskState(@JsonProperty(value="taskClass") Class<?> taskClass, @JsonProperty(value="creator") String creator, @JsonProperty(value="id") TaskId id, @JsonProperty(value="status") TaskStatus status) {
        this.status = status;
        this.statusChangeTime = Instant.now();
        this.taskClassName = taskClass != null ? taskClass.getName() : null;
        this.creator = creator;
        this.taskId = id.value();
    }

    public TaskState(Class<?> taskClass, String creator, TaskId id) {
        this(taskClass, creator, id, TaskStatus.CREATED);
    }

    private TaskState(TaskState taskState) {
        this.taskId = taskState.taskId;
        this.status = taskState.status;
        this.statusChangeTime = taskState.statusChangeTime;
        this.taskClassName = taskState.taskClassName;
        this.creator = taskState.creator;
        this.engineID = taskState.engineID;
        this.stackTrace = taskState.stackTrace;
        this.exception = taskState.exception;
    }

    @JsonProperty(value="id")
    public TaskId getId() {
        return TaskId.of((String)this.taskId);
    }

    public TaskState markFailed(String reason) {
        this.status = TaskStatus.FAILED;
        this.exception = reason;
        this.stackTrace = "No Stack Trace Provided";
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskStatus status() {
        return this.status;
    }

    public Instant statusChangeTime() {
        return this.statusChangeTime;
    }

    public Class<? extends BackgroundTask> taskClass() {
        try {
            return Class.forName(this.taskClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String stackTrace() {
        return this.stackTrace;
    }

    public String exception() {
        return this.exception;
    }

    public TaskState copy() {
        return new TaskState(this);
    }

    @JsonProperty(value="serialVersionUID")
    public static long getSerialVersionUID() {
        return -7301340972479426653L;
    }

    @JsonProperty(value="status")
    public TaskStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="taskClassName")
    public String getTaskClassName() {
        return this.taskClassName;
    }

    @JsonProperty(value="engineId")
    public EngineID getEngineID() {
        return this.engineID;
    }

    public String toString() {
        return "TaskState(" + this.taskClass().getSimpleName() + ", \"" + this.getId() + "\").status(" + this.status() + ")";
    }
}

