/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager.redisqueue;

import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.postprocessing.PostProcessor;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.redisqueue.RedisTaskManager;
import ai.grakn.engine.tasks.manager.redisqueue.Task;
import ai.grakn.engine.util.EngineID;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class RedisTaskQueueConsumer
implements Consumer<Task> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTaskQueueConsumer.class);
    private final RedisTaskManager redisTaskManager;
    private final EngineID engineId;
    private final GraknConfig config;
    private final MetricRegistry metricRegistry;
    private final EngineGraknTxFactory factory;
    private final PostProcessor postProcessor;

    public RedisTaskQueueConsumer(RedisTaskManager redisTaskManager, EngineID engineId, GraknConfig config, MetricRegistry metricRegistry, EngineGraknTxFactory factory, PostProcessor postProcessor) {
        this.redisTaskManager = redisTaskManager;
        this.engineId = engineId;
        this.config = config;
        this.metricRegistry = metricRegistry;
        this.factory = factory;
        this.postProcessor = postProcessor;
    }

    private void checkPreconditions() {
        try {
            Preconditions.checkNotNull((Object)this.metricRegistry);
            Preconditions.checkNotNull((Object)this.engineId);
            Preconditions.checkNotNull((Object)this.config);
            Preconditions.checkNotNull((Object)this.redisTaskManager);
            Preconditions.checkNotNull((Object)this.postProcessor);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(String.format("%s was started but the state wasn't set explicitly", this.getClass().getName()));
        }
    }

    private boolean taskShouldResume(Task task) {
        return task.getTaskState().status() == TaskStatus.RUNNING;
    }

    @Override
    public void accept(Task task) {
        this.checkPreconditions();
        Timer executeTimer = this.metricRegistry.timer(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"execute"}));
        Timer.Context context = executeTimer.time();
        TaskState taskState = task.getTaskState();
        TaskConfiguration taskConfiguration = task.getTaskConfiguration();
        try {
            BackgroundTask runningTask = taskState.taskClass().newInstance();
            runningTask.initialize(taskConfiguration, this.config, this.factory, this.metricRegistry, this.postProcessor);
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"initialized"})).mark();
            if (this.taskShouldResume(task)) {
                throw new NotImplementedException();
            }
            runningTask.start();
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"run"})).mark();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"failed"})).mark();
            LOG.error("{} had an instantiantion exception", (Object)task.getTaskState().getId(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException throwable) {
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"failed"})).mark();
            LOG.error("{} could not be completed successfully", (Object)task.getTaskState().getId(), (Object)throwable);
            throw new RuntimeException(throwable);
        }
        finally {
            context.stop();
        }
    }
}

