/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.mock;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.tasks.BackgroundTask;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMultiset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MockBackgroundTask
extends BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(MockBackgroundTask.class);
    private static final ConcurrentHashMultiset<TaskId> COMPLETED_TASKS = ConcurrentHashMultiset.create();
    private static final ConcurrentHashMultiset<TaskId> CANCELLED_TASKS = ConcurrentHashMultiset.create();
    private static Consumer<TaskId> onTaskStart;
    private static Consumer<TaskId> onTaskFinish;
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);
    protected final Object sync = new Object();
    private TaskId id;

    private static void addCompletedTask(TaskId taskId) {
        COMPLETED_TASKS.add((Object)taskId);
    }

    public static ImmutableMultiset<TaskId> completedTasks() {
        return ImmutableMultiset.copyOf(COMPLETED_TASKS);
    }

    private static void addCancelledTask(TaskId taskId) {
        CANCELLED_TASKS.add((Object)taskId);
    }

    public static ImmutableMultiset<TaskId> cancelledTasks() {
        return ImmutableMultiset.copyOf(CANCELLED_TASKS);
    }

    public static void whenTaskStarts(Consumer<TaskId> beforeTaskStarts) {
        onTaskStart = beforeTaskStarts;
    }

    private static void onTaskStart(TaskId taskId) {
        if (onTaskStart != null) {
            onTaskStart.accept(taskId);
        }
    }

    public static void whenTaskFinishes(Consumer<TaskId> onTaskFinish) {
        MockBackgroundTask.onTaskFinish = onTaskFinish;
    }

    private static void onTaskFinish(TaskId taskId) {
        if (onTaskFinish != null) {
            onTaskFinish.accept(taskId);
        }
    }

    public static void clearTasks() {
        COMPLETED_TASKS.clear();
        CANCELLED_TASKS.clear();
        onTaskStart = null;
        onTaskFinish = null;
    }

    @Override
    public final boolean start() {
        Json json = Json.read((String)this.configuration().configuration());
        if (json.equals(Json.object())) {
            throw new RuntimeException("Invalid task config");
        }
        Json id = json.at("id");
        if (id == null) {
            LOG.error("Missing id in {}: {}", (Object)this.getClass().getName(), (Object)json);
        }
        this.id = TaskId.generate();
        MockBackgroundTask.onTaskStart(this.id);
        boolean wasCancelled = this.cancelled.get();
        if (!wasCancelled) {
            this.executeStartInner(this.id);
        }
        if (!(wasCancelled = this.cancelled.get())) {
            MockBackgroundTask.addCompletedTask(this.id);
        } else {
            MockBackgroundTask.addCancelledTask(this.id);
        }
        MockBackgroundTask.onTaskFinish(this.id);
        return !wasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean stop() {
        this.cancelled.set(true);
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        return true;
    }

    protected abstract void executeStartInner(TaskId var1);
}

