/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.KeyspaceStore;
import ai.grakn.engine.ServerHTTP;
import ai.grakn.engine.ServerStatus;
import ai.grakn.engine.data.QueueSanityCheck;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.task.BackgroundTaskRunner;
import ai.grakn.engine.util.EngineID;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements AutoCloseable {
    private static final String LOAD_SYSTEM_SCHEMA_LOCK_NAME = "load-system-schema";
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private final EngineID engineId;
    private final GraknConfig config;
    private final ServerStatus serverStatus;
    private final LockProvider lockProvider;
    private final QueueSanityCheck queueSanityCheck;
    private final ServerHTTP httpHandler;
    private final BackgroundTaskRunner backgroundTaskRunner;
    private final KeyspaceStore keyspaceStore;

    public Server(EngineID engineId, GraknConfig config, ServerStatus serverStatus, LockProvider lockProvider, QueueSanityCheck queueSanityCheck, ServerHTTP httpHandler, BackgroundTaskRunner backgroundTaskRunner, KeyspaceStore keyspaceStore) {
        this.config = config;
        this.serverStatus = serverStatus;
        this.queueSanityCheck = queueSanityCheck;
        this.lockProvider = lockProvider;
        this.keyspaceStore = keyspaceStore;
        this.httpHandler = httpHandler;
        this.engineId = engineId;
        this.backgroundTaskRunner = backgroundTaskRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.queueSanityCheck.testConnection();
        Stopwatch timer = Stopwatch.createStarted();
        this.logStartMessage((String)this.config.getProperty(GraknConfigKey.SERVER_HOST_NAME), (Integer)this.config.getProperty(GraknConfigKey.SERVER_PORT));
        Server server = this;
        synchronized (server) {
            this.queueSanityCheck.checkVersion();
            this.lockAndInitializeSystemSchema();
            this.httpHandler.startHTTP();
        }
        this.serverStatus.setReady(true);
        LOG.info("Grakn started in {}", (Object)timer.stop());
    }

    @VisibleForTesting
    public BackgroundTaskRunner backgroundTaskRunner() {
        return this.backgroundTaskRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Server server = this;
        synchronized (server) {
            try {
                this.httpHandler.stopHTTP();
            }
            catch (InterruptedException e) {
                LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            this.queueSanityCheck.close();
            this.backgroundTaskRunner.close();
        }
    }

    private void lockAndInitializeSystemSchema() {
        block6: {
            try {
                Lock lock = this.lockProvider.getLock(LOAD_SYSTEM_SCHEMA_LOCK_NAME);
                if (lock.tryLock(60L, TimeUnit.SECONDS)) {
                    try {
                        LOG.info("{} is checking the system schema", (Object)this.engineId);
                        this.keyspaceStore.loadSystemSchema();
                        break block6;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                LOG.info("{} found system schema lock already acquired by other engine", (Object)this.engineId);
            }
            catch (InterruptedException e) {
                LOG.warn("{} was interrupted while initializing system schema", (Object)this.engineId);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void logStartMessage(String host, int port) {
        String address = "http://" + host + ":" + port;
        LOG.info("\n==================================================");
        LOG.info("\n" + String.format(GraknConfig.GRAKN_ASCII, address));
        LOG.info("\n==================================================");
    }

    public ServerHTTP getHttpHandler() {
        return this.httpHandler;
    }

    public LockProvider lockProvider() {
        return this.lockProvider;
    }
}

