/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.KeyspaceStore;
import ai.grakn.engine.Server;
import ai.grakn.engine.ServerHTTP;
import ai.grakn.engine.ServerRPC;
import ai.grakn.engine.ServerStatus;
import ai.grakn.engine.controller.HttpController;
import ai.grakn.engine.data.QueueSanityCheck;
import ai.grakn.engine.data.RedisSanityCheck;
import ai.grakn.engine.data.RedisWrapper;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.JedisLockProvider;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.rpc.KeyspaceService;
import ai.grakn.engine.rpc.ServerOpenRequest;
import ai.grakn.engine.rpc.SessionService;
import ai.grakn.engine.task.BackgroundTaskRunner;
import ai.grakn.engine.task.postprocessing.CountPostProcessor;
import ai.grakn.engine.task.postprocessing.IndexPostProcessor;
import ai.grakn.engine.task.postprocessing.PostProcessingTask;
import ai.grakn.engine.task.postprocessing.PostProcessor;
import ai.grakn.engine.task.postprocessing.redisstorage.RedisCountStorage;
import ai.grakn.engine.task.postprocessing.redisstorage.RedisIndexStorage;
import ai.grakn.engine.util.EngineID;
import ai.grakn.keyspace.KeyspaceStoreImpl;
import com.codahale.metrics.MetricRegistry;
import io.grpc.BindableService;
import io.grpc.ServerBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import spark.Service;

public class ServerFactory {
    public static Server createServer() {
        EngineID engineId = EngineID.me();
        GraknConfig config = GraknConfig.create();
        ServerStatus status = new ServerStatus();
        MetricRegistry metricRegistry = new MetricRegistry();
        RedisWrapper redisWrapper = RedisWrapper.create(config);
        RedisSanityCheck queueSanityCheck = new RedisSanityCheck(redisWrapper);
        JedisLockProvider lockProvider = new JedisLockProvider(redisWrapper.getJedisPool());
        KeyspaceStoreImpl keyspaceStore = new KeyspaceStoreImpl(config);
        EngineGraknTxFactory engineGraknTxFactory = EngineGraknTxFactory.create(lockProvider, config, (KeyspaceStore)keyspaceStore);
        RedisIndexStorage indexStorage = RedisIndexStorage.create(redisWrapper.getJedisPool(), metricRegistry);
        RedisCountStorage countStorage = RedisCountStorage.create(redisWrapper.getJedisPool(), metricRegistry);
        IndexPostProcessor indexPostProcessor = IndexPostProcessor.create(lockProvider, indexStorage);
        CountPostProcessor countPostProcessor = CountPostProcessor.create(config, engineGraknTxFactory, lockProvider, metricRegistry, countStorage);
        PostProcessor postProcessor = PostProcessor.create(indexPostProcessor, countPostProcessor);
        Service sparkHttp = Service.ignite();
        List<HttpController> httpControllers = Collections.emptyList();
        ServerRPC rpcServerRPC = ServerFactory.configureServerRPC(config, engineGraknTxFactory, postProcessor, (KeyspaceStore)keyspaceStore);
        return ServerFactory.createServer(engineId, config, status, sparkHttp, httpControllers, rpcServerRPC, engineGraknTxFactory, metricRegistry, queueSanityCheck, lockProvider, postProcessor, (KeyspaceStore)keyspaceStore);
    }

    public static Server createServer(EngineID engineId, GraknConfig config, ServerStatus serverStatus, Service sparkHttp, Collection<HttpController> httpControllers, ServerRPC rpcServerRPC, EngineGraknTxFactory engineGraknTxFactory, MetricRegistry metricRegistry, QueueSanityCheck queueSanityCheck, LockProvider lockProvider, PostProcessor postProcessor, KeyspaceStore keyspaceStore) {
        ServerHTTP httpHandler = new ServerHTTP(config, sparkHttp, engineGraknTxFactory, metricRegistry, serverStatus, postProcessor, rpcServerRPC, httpControllers);
        BackgroundTaskRunner taskRunner = ServerFactory.configureBackgroundTaskRunner(config, engineGraknTxFactory, postProcessor.index());
        Server server = new Server(engineId, config, serverStatus, lockProvider, queueSanityCheck, httpHandler, taskRunner, keyspaceStore);
        Thread thread = new Thread(server::close, "grakn-server-shutdown");
        Runtime.getRuntime().addShutdownHook(thread);
        return server;
    }

    private static BackgroundTaskRunner configureBackgroundTaskRunner(GraknConfig graknEngineConfig, EngineGraknTxFactory factory, IndexPostProcessor postProcessor) {
        PostProcessingTask postProcessingTask = new PostProcessingTask(factory, postProcessor, graknEngineConfig);
        BackgroundTaskRunner taskRunner = new BackgroundTaskRunner(graknEngineConfig);
        taskRunner.register(postProcessingTask);
        return taskRunner;
    }

    private static ServerRPC configureServerRPC(GraknConfig config, EngineGraknTxFactory engineGraknTxFactory, PostProcessor postProcessor, KeyspaceStore keyspaceStore) {
        int grpcPort = (Integer)config.getProperty(GraknConfigKey.GRPC_PORT);
        ServerOpenRequest requestOpener = new ServerOpenRequest(engineGraknTxFactory);
        io.grpc.Server grpcServer = ServerBuilder.forPort((int)grpcPort).addService((BindableService)new SessionService(requestOpener, postProcessor)).addService((BindableService)new KeyspaceService(keyspaceStore)).build();
        return ServerRPC.create(grpcServer);
    }
}

