/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.ServerRPC;
import ai.grakn.engine.ServerStatus;
import ai.grakn.engine.controller.ConceptController;
import ai.grakn.engine.controller.GraqlController;
import ai.grakn.engine.controller.HttpController;
import ai.grakn.engine.controller.SystemController;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.printer.JacksonPrinter;
import ai.grakn.engine.task.postprocessing.PostProcessor;
import ai.grakn.exception.GraknServerException;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import mjson.Json;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Response;
import spark.Service;

public class ServerHTTP {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHTTP.class);
    private final GraknConfig prop;
    private final Service spark;
    private final EngineGraknTxFactory factory;
    private final MetricRegistry metricRegistry;
    private final ServerStatus serverStatus;
    private final PostProcessor postProcessor;
    private final ServerRPC rpcServerRPC;
    private final Collection<HttpController> additionalCollaborators;

    public ServerHTTP(GraknConfig prop, Service spark, EngineGraknTxFactory factory, MetricRegistry metricRegistry, ServerStatus serverStatus, PostProcessor postProcessor, ServerRPC rpcServerRPC, Collection<HttpController> additionalCollaborators) {
        this.prop = prop;
        this.spark = spark;
        this.factory = factory;
        this.metricRegistry = metricRegistry;
        this.serverStatus = serverStatus;
        this.postProcessor = postProcessor;
        this.rpcServerRPC = rpcServerRPC;
        this.additionalCollaborators = additionalCollaborators;
    }

    public void startHTTP() throws IOException {
        ServerHTTP.configureSpark(this.spark, this.prop);
        this.startCollaborators();
        this.rpcServerRPC.start();
        this.spark.awaitInitialization();
    }

    protected void startCollaborators() {
        JacksonPrinter printer = JacksonPrinter.create();
        new GraqlController(this.factory, this.postProcessor, printer, this.metricRegistry).start(this.spark);
        new ConceptController(this.factory, this.metricRegistry).start(this.spark);
        new SystemController(this.prop, this.factory.keyspaceStore(), this.serverStatus, this.metricRegistry).start(this.spark);
        this.additionalCollaborators.forEach(httpController -> httpController.start(this.spark));
    }

    public static void configureSpark(Service spark, GraknConfig prop) {
        ServerHTTP.configureSpark(spark, (String)prop.getProperty(GraknConfigKey.SERVER_HOST_NAME), (Integer)prop.getProperty(GraknConfigKey.SERVER_PORT), prop.getPath(GraknConfigKey.STATIC_FILES_PATH), (Integer)prop.getProperty(GraknConfigKey.WEBSERVER_THREADS));
    }

    public static void configureSpark(Service spark, String hostName, int port, Path staticFolder, int maxThreads) {
        spark.ipAddress(hostName);
        spark.port(port);
        spark.staticFiles.externalLocation(staticFolder.toString());
        spark.threadPool(maxThreads);
        spark.exception(GraknServerException.class, (e, req, res) -> {
            assert (e instanceof GraknServerException);
            ServerHTTP.handleGraknServerError((GraknServerException)e, res);
        });
        spark.exception(Exception.class, (e, req, res) -> ServerHTTP.handleInternalError(e, res));
    }

    public void stopHTTP() throws InterruptedException {
        this.rpcServerRPC.close();
        this.spark.stop();
        boolean running = true;
        while (running) {
            try {
                this.spark.port();
            }
            catch (IllegalStateException e) {
                LOG.debug("Spark server has been stopped");
                running = false;
            }
        }
    }

    protected static void handleGraknServerError(GraknServerException exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(exception.getStatus());
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }

    protected static void handleInternalError(Exception exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(500);
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }
}

