/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.engine.bootup.BootupProcessResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public class BootupProcessExecutor {
    public static final long WAIT_INTERVAL_SECOND = 2L;
    public static final String SH = "/bin/sh";

    public CompletableFuture<BootupProcessResult> executeAsync(List<String> command, File workingDirectory) {
        return CompletableFuture.supplyAsync(() -> this.executeAndWait(command, workingDirectory));
    }

    public BootupProcessResult executeAndWait(List<String> command, File workingDirectory) {
        try {
            ByteArrayOutputStream stderr = new ByteArrayOutputStream();
            ProcessResult result = new ProcessExecutor().readOutput(true).redirectError((OutputStream)stderr).directory(workingDirectory).command(command).execute();
            return BootupProcessResult.create(result.outputUTF8(), stderr.toString(StandardCharsets.UTF_8.name()), result.getExitValue());
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<String> getPidFromFile(Path fileName) {
        String pid = null;
        if (fileName.toFile().exists()) {
            try {
                pid = new String(Files.readAllBytes(fileName), StandardCharsets.UTF_8).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.ofNullable(pid);
    }

    public String getPidFromPsOf(String processName) {
        return this.executeAndWait(Arrays.asList(SH, "-c", "ps -ef | grep " + processName + " | grep -v grep | awk '{print $2}' "), null).stdout();
    }

    public int retrievePid(Path pidFile) {
        if (!pidFile.toFile().exists()) {
            return -1;
        }
        try {
            String pid = new String(Files.readAllBytes(pidFile), StandardCharsets.UTF_8);
            pid = pid.trim();
            return Integer.parseInt(pid);
        }
        catch (IOException | NumberFormatException e) {
            return -1;
        }
    }

    public void waitUntilStopped(Path pidFile, int pid) {
        BootupProcessResult bootupProcessResult;
        do {
            System.out.print(".");
            System.out.flush();
            bootupProcessResult = this.kill(pid, "0");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (bootupProcessResult.success());
        System.out.println("SUCCESS");
        FileUtils.deleteQuietly((File)pidFile.toFile());
    }

    public boolean isProcessRunning(Path pidFile) {
        boolean isRunning = false;
        if (pidFile.toFile().exists()) {
            try {
                String processPid = new String(Files.readAllBytes(pidFile), StandardCharsets.UTF_8);
                if (processPid.trim().isEmpty()) {
                    return false;
                }
                BootupProcessResult command = this.executeAndWait(Arrays.asList(SH, "-c", "ps -p " + processPid.trim() + " | grep -v CMD | wc -l"), null);
                return Integer.parseInt(command.stdout().trim()) > 0;
            }
            catch (IOException | NumberFormatException e) {
                return false;
            }
        }
        return isRunning;
    }

    public void stopProcessIfRunning(Path pidFile, String programName) {
        System.out.print("Stopping " + programName + "...");
        System.out.flush();
        boolean programIsRunning = this.isProcessRunning(pidFile);
        if (!programIsRunning) {
            System.out.println("NOT RUNNING");
        } else {
            this.stopProcess(pidFile);
        }
    }

    public void processStatus(Path storagePid, String name) {
        if (this.isProcessRunning(storagePid)) {
            System.out.println(name + ": RUNNING");
        } else {
            System.out.println(name + ": NOT RUNNING");
        }
    }

    private void stopProcess(Path pidFile) {
        int pid = this.retrievePid(pidFile);
        if (pid < 0) {
            return;
        }
        this.kill(pid);
        this.waitUntilStopped(pidFile, pid);
    }

    private void kill(int pid) {
        this.executeAndWait(Arrays.asList(SH, "-c", "kill " + pid), null);
    }

    private BootupProcessResult kill(int pid, String signal) {
        return this.executeAndWait(Arrays.asList(SH, "-c", "kill -" + signal + " " + pid), null);
    }
}

