/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.GraknConfigKey;
import ai.grakn.GraknSystemProperty;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.BootupException;
import ai.grakn.engine.bootup.BootupProcessExecutor;
import ai.grakn.engine.bootup.BootupProcessResult;
import ai.grakn.engine.bootup.Grakn;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.SimpleURI;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.UriBuilder;

public class EngineBootup {
    private static final String DISPLAY_NAME = "Engine";
    private static final long ENGINE_STARTUP_TIMEOUT_S = 300L;
    private static final Path ENGINE_PIDFILE = Paths.get(File.separator, "tmp", "grakn-engine.pid");
    private static final String JAVA_OPTS = Optional.ofNullable(GraknSystemProperty.ENGINE_JAVAOPTS.value()).orElse("");
    protected final Path graknHome;
    protected final Path graknPropertiesPath;
    private final GraknConfig graknProperties;
    private BootupProcessExecutor bootupProcessExecutor;

    public EngineBootup(BootupProcessExecutor bootupProcessExecutor, Path graknHome, Path graknPropertiesPath) {
        this.bootupProcessExecutor = bootupProcessExecutor;
        this.graknHome = graknHome;
        this.graknPropertiesPath = graknPropertiesPath;
        this.graknProperties = GraknConfig.read((File)graknPropertiesPath.toFile());
    }

    public Class getEngineMainClass() {
        return Grakn.class;
    }

    public void startIfNotRunning() {
        boolean isEngineRunning = this.bootupProcessExecutor.isProcessRunning(ENGINE_PIDFILE);
        if (isEngineRunning) {
            System.out.println("Engine is already running");
        } else {
            this.start();
        }
    }

    public void stop() {
        this.bootupProcessExecutor.stopProcessIfRunning(ENGINE_PIDFILE, DISPLAY_NAME);
    }

    public void status() {
        this.bootupProcessExecutor.processStatus(ENGINE_PIDFILE, DISPLAY_NAME);
    }

    public void statusVerbose() {
        System.out.println("Engine pid = '" + this.bootupProcessExecutor.getPidFromFile(ENGINE_PIDFILE).orElse("") + "' (from " + ENGINE_PIDFILE + "), '" + this.bootupProcessExecutor.getPidFromPsOf(this.getEngineMainClass().getName()) + "' (from ps -ef)");
    }

    public void clean() {
        System.out.print("Cleaning Engine...");
        System.out.flush();
        Path rootPath = this.graknHome.resolve("logs");
        try (Stream<Path> files = Files.walk(rootPath, new FileVisitOption[0]);){
            files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            Files.createDirectories(this.graknHome.resolve("logs"), new FileAttribute[0]);
            System.out.println("SUCCESS");
        }
        catch (IOException e) {
            System.out.println("FAILED!");
            System.out.println("Unable to clean Engine");
        }
    }

    public boolean isRunning() {
        return this.bootupProcessExecutor.isProcessRunning(ENGINE_PIDFILE);
    }

    private void start() {
        List<String> startEngineCmd_EscapeWhitespace = Arrays.asList("/bin/sh", "-c", "java " + JAVA_OPTS + " -cp " + this.getEngineJavaClassPath().replace(" ", "\\ ") + " -Dgrakn.dir=" + this.graknHome.toString().replace(" ", "\\ ") + " -Dgrakn.conf=" + this.graknPropertiesPath.toString().replace(" ", "\\ ") + " -Dgrakn.pidfile=" + ENGINE_PIDFILE.toString().replace(" ", "\\ ") + " " + this.getEngineMainClass().getName());
        System.out.print("Starting Engine...");
        System.out.flush();
        CompletableFuture<BootupProcessResult> startEngineAsync = this.bootupProcessExecutor.executeAsync(startEngineCmd_EscapeWhitespace, this.graknHome.toFile());
        LocalDateTime init = LocalDateTime.now();
        LocalDateTime timeout = init.plusSeconds(300L);
        while (LocalDateTime.now().isBefore(timeout) && !startEngineAsync.isDone()) {
            System.out.print(".");
            System.out.flush();
            String host = (String)this.graknProperties.getProperty(GraknConfigKey.SERVER_HOST_NAME);
            int port = (Integer)this.graknProperties.getProperty(GraknConfigKey.SERVER_PORT);
            if (this.bootupProcessExecutor.isProcessRunning(ENGINE_PIDFILE) && this.isEngineReady(host, port, "/status")) {
                System.out.println("SUCCESS");
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        String errorMessage = "";
        try {
            errorMessage = "Process exited with code '" + startEngineAsync.get().exitCode() + "': '" + startEngineAsync.get().stderr() + "'";
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        System.out.println("FAILED!");
        System.err.println("Unable to start Engine.");
        System.err.println(errorMessage);
        throw new BootupException();
    }

    private boolean isEngineReady(String host, int port, String path) {
        try {
            URL engineUrl = UriBuilder.fromUri((URI)new SimpleURI(host, port).toURI()).path(path).build(new Object[0]).toURL();
            HttpURLConnection connection = (HttpURLConnection)engineUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int code = connection.getResponseCode();
            return code == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getEngineJavaClassPath() {
        FilenameFilter filterForJarFiles = (dir, name) -> name.toLowerCase().endsWith(".jar");
        File servicesLibDir = Paths.get("services", "lib").toFile();
        File[] jarFiles = servicesLibDir.listFiles(filterForJarFiles);
        if (jarFiles == null) {
            throw new RuntimeException(ErrorMessage.UNABLE_TO_START_ENGINE_JAR_NOT_FOUND.getMessage(new Object[0]));
        }
        Stream<File> jars = Stream.of(jarFiles);
        File conf = Paths.get("./conf", new String[0]).toFile();
        File graknLogback = Paths.get("services", "grakn", "server").toFile();
        String classPath = ":" + Stream.concat(jars, Stream.of(conf, graknLogback)).filter(f -> !f.getName().contains("slf4j-log4j12")).map(f -> f.toPath().toString()).sorted().collect(Collectors.joining(":"));
        return classPath;
    }
}

