/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.engine.bootup.BootupException;
import ai.grakn.util.ErrorMessage;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginePidManager {
    private static final Logger LOG = LoggerFactory.getLogger(EnginePidManager.class);
    private Path pidFile;

    public EnginePidManager(Path pidFile) {
        this.pidFile = pidFile;
    }

    public void trackGraknPid() {
        long pid = this.getPid();
        this.trackGraknPid(pid);
    }

    private long getPid() {
        String[] pidAndHostnameString = ManagementFactory.getRuntimeMXBean().getName().split("@");
        String pidString = pidAndHostnameString[0];
        try {
            return Long.parseLong(pidString);
        }
        catch (NumberFormatException e) {
            throw new BootupException(ErrorMessage.COULD_NOT_GET_PID.getMessage(new Object[]{pidString}), e);
        }
    }

    private void trackGraknPid(long graknPid) {
        this.attemptToWritePidFile(graknPid, this.pidFile);
        this.deletePidFileOnExit();
    }

    private void deletePidFileOnExit() {
        this.pidFile.toFile().deleteOnExit();
    }

    private void attemptToWritePidFile(long pid, Path pidFilePath) {
        if (pidFilePath.toFile().exists()) {
            LOG.warn(ErrorMessage.PID_ALREADY_EXISTS.getMessage(new Object[]{pidFilePath.toString()}));
        }
        String pidString = Long.toString(pid);
        try {
            Files.write(pidFilePath, pidString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BootupException(e);
        }
    }
}

