/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.GraknSystemProperty;
import ai.grakn.engine.Server;
import ai.grakn.engine.ServerFactory;
import ai.grakn.engine.bootup.EnginePidManager;
import ai.grakn.util.ErrorMessage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grakn {
    private static final Logger LOG = LoggerFactory.getLogger(Grakn.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOG.error(ErrorMessage.UNCAUGHT_EXCEPTION.getMessage(new Object[]{t.getName()}), e));
        try {
            String graknPidFileProperty = Optional.ofNullable(GraknSystemProperty.GRAKN_PID_FILE.value()).orElseThrow(() -> new RuntimeException(ErrorMessage.GRAKN_PIDFILE_SYSTEM_PROPERTY_UNDEFINED.getMessage(new Object[0])));
            Path pidfile = Paths.get(graknPidFileProperty, new String[0]);
            EnginePidManager enginePidManager = new EnginePidManager(pidfile);
            enginePidManager.trackGraknPid();
            Server server = ServerFactory.createServer();
            server.start();
        }
        catch (IOException | RuntimeException e2) {
            LOG.error(ErrorMessage.UNCAUGHT_EXCEPTION.getMessage(new Object[]{e2.getMessage()}), (Throwable)e2);
        }
    }
}

