/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.GraknSystemProperty;
import ai.grakn.engine.bootup.BootupProcessExecutor;
import ai.grakn.engine.bootup.EngineBootup;
import ai.grakn.engine.bootup.QueueBootup;
import ai.grakn.engine.bootup.StorageBootup;
import ai.grakn.engine.bootup.config.ConfigProcessor;
import ai.grakn.util.ErrorMessage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraknBootup {
    private static final Logger LOG = LoggerFactory.getLogger(GraknBootup.class);
    private static final String ENGINE = "engine";
    private static final String QUEUE = "queue";
    private static final String STORAGE = "storage";
    private final StorageBootup storageBootup;
    private final QueueBootup queueBootup;
    private final EngineBootup engineBootup;

    public static void main(String[] args) {
        try {
            Path graknHome = Paths.get(GraknSystemProperty.CURRENT_DIRECTORY.value(), new String[0]);
            Path graknProperties = Paths.get(GraknSystemProperty.CONFIGURATION_FILE.value(), new String[0]);
            GraknBootup.assertEnvironment(graknHome, graknProperties);
            GraknBootup.printGraknLogo();
            BootupProcessExecutor bootupProcessExecutor = new BootupProcessExecutor();
            GraknBootup graknBootup = new GraknBootup(new StorageBootup(bootupProcessExecutor, graknHome, graknProperties), new QueueBootup(bootupProcessExecutor, graknHome), new EngineBootup(bootupProcessExecutor, graknHome, graknProperties));
            graknBootup.run(args);
            System.exit(0);
        }
        catch (RuntimeException ex) {
            LOG.error(ErrorMessage.UNABLE_TO_START_GRAKN.getMessage(new Object[0]), (Throwable)ex);
            System.out.println(ErrorMessage.UNABLE_TO_START_GRAKN.getMessage(new Object[0]));
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private GraknBootup(StorageBootup storageBootup, QueueBootup queueBootup, EngineBootup engineBootup) {
        this.storageBootup = storageBootup;
        this.queueBootup = queueBootup;
        this.engineBootup = engineBootup;
    }

    private static void assertEnvironment(Path graknHome, Path graknProperties) {
        String javaVersion = System.getProperty("java.specification.version");
        if (!javaVersion.equals("1.8")) {
            throw new RuntimeException(ErrorMessage.UNSUPPORTED_JAVA_VERSION.getMessage(new Object[]{javaVersion}));
        }
        if (!graknHome.resolve("grakn").toFile().exists()) {
            throw new RuntimeException(ErrorMessage.UNABLE_TO_GET_GRAKN_HOME_FOLDER.getMessage(new Object[0]));
        }
        if (!graknProperties.toFile().exists()) {
            throw new RuntimeException(ErrorMessage.UNABLE_TO_GET_GRAKN_CONFIG_FOLDER.getMessage(new Object[0]));
        }
    }

    private static void printGraknLogo() {
        Path ascii = Paths.get(".", "services", "grakn", "grakn-ascii.txt");
        if (ascii.toFile().exists()) {
            try {
                System.out.println(new String(Files.readAllBytes(ascii), StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run(String[] args) {
        String context = args.length > 0 ? args[0] : "";
        String action = args.length > 1 ? args[1] : "";
        String option = args.length > 2 ? args[2] : "";
        switch (context) {
            case "server": {
                this.server(action, option);
                break;
            }
            case "version": {
                this.version();
                break;
            }
            default: {
                this.help();
            }
        }
    }

    private void server(String action, String option) {
        switch (action) {
            case "start": {
                this.serverStart(option);
                break;
            }
            case "stop": {
                this.serverStop(option);
                break;
            }
            case "status": {
                this.serverStatus(option);
                break;
            }
            case "clean": {
                this.clean();
                break;
            }
            default: {
                this.serverHelp();
            }
        }
    }

    private void serverStop(String arg) {
        switch (arg) {
            case "engine": {
                this.engineBootup.stop();
                break;
            }
            case "queue": {
                this.queueBootup.stop();
                break;
            }
            case "storage": {
                this.storageBootup.stop();
                break;
            }
            default: {
                this.engineBootup.stop();
                this.queueBootup.stop();
                this.storageBootup.stop();
            }
        }
    }

    private void serverStart(String arg) {
        switch (arg) {
            case "engine": {
                this.engineBootup.startIfNotRunning();
                break;
            }
            case "queue": {
                this.queueBootup.startIfNotRunning();
                break;
            }
            case "storage": {
                this.storageBootup.startIfNotRunning();
                break;
            }
            default: {
                ConfigProcessor.updateProcessConfigs();
                this.storageBootup.startIfNotRunning();
                this.queueBootup.startIfNotRunning();
                this.engineBootup.startIfNotRunning();
            }
        }
    }

    private void serverHelp() {
        System.out.println("Usage: grakn server COMMAND\n\nCOMMAND:\nstart [engine|queue|storage]  Start Grakn (or optionally, only one of the component)\nstop [engine|queue|storage]   Stop Grakn (or optionally, only one of the component)\nstatus                         Check if Grakn is running\nclean                          DANGEROUS: wipe data completely\n\nTips:\n- Start Grakn with 'grakn server start'\n- Start or stop only one component with, e.g. 'grakn server start storage' or 'grakn server stop storage', respectively\n");
    }

    private void serverStatus(String verboseFlag) {
        this.storageBootup.status();
        this.queueBootup.status();
        this.engineBootup.status();
        if (verboseFlag.equals("--verbose")) {
            System.out.println("======== Failure Diagnostics ========");
            this.storageBootup.statusVerbose();
            this.queueBootup.statusVerbose();
            this.engineBootup.statusVerbose();
        }
    }

    private void version() {
        System.out.println("1.4.0");
    }

    private void help() {
        System.out.println("Usage: grakn COMMAND\n\nCOMMAND:\nserver     Manage Grakn components\nversion    Print Grakn version\nhelp       Print this message\n\nTips:\n- Start Grakn with 'grakn server start' (by default, the dashboard will be accessible at http://localhost:4567)\n- You can then perform queries by opening a console with 'graql console'");
    }

    private void clean() {
        boolean storage = this.storageBootup.isRunning();
        boolean queue = this.queueBootup.isRunning();
        boolean grakn = this.engineBootup.isRunning();
        if (storage || queue || grakn) {
            System.out.println("Grakn is still running! Please do a shutdown with 'grakn server stop' before performing a cleanup.");
            return;
        }
        System.out.print("Are you sure you want to delete all stored data and logs? [y/N] ");
        System.out.flush();
        String response = new Scanner(System.in, StandardCharsets.UTF_8.name()).next();
        if (!response.equals("y") && !response.equals("Y")) {
            System.out.println("Response '" + response + "' did not equal 'y' or 'Y'.  Canceling clean operation.");
            return;
        }
        this.storageBootup.clean();
        this.queueBootup.clean();
        this.engineBootup.clean();
    }
}

