/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.graql.shell.GraqlConsole;
import ai.grakn.graql.shell.GraqlShellOptions;
import ai.grakn.graql.shell.GraqlShellOptionsFactory;
import ai.grakn.migration.csv.CSVMigrator;
import ai.grakn.migration.export.Main;
import ai.grakn.migration.json.JsonMigrator;
import ai.grakn.migration.sql.SQLMigrator;
import ai.grakn.migration.xml.XmlMigrator;
import ai.grakn.util.ErrorMessage;
import com.google.common.base.StandardSystemProperty;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.commons.cli.ParseException;

public class Graql {
    private final GraqlShellOptionsFactory graqlShellOptionsFactory;
    private static final String HISTORY_FILENAME = StandardSystemProperty.USER_HOME.value() + "/.graql-history";

    public Graql(GraqlShellOptionsFactory graqlShellOptionsFactory) {
        this.graqlShellOptionsFactory = graqlShellOptionsFactory;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        GraqlShellOptionsFactory graqlShellOptionsFactory = GraqlShellOptions::create;
        new Graql(graqlShellOptionsFactory).run(args);
    }

    public void run(String[] args) throws IOException, InterruptedException {
        String context;
        switch (context = args.length > 0 ? args[0] : "") {
            case "console": {
                GraqlShellOptions options;
                try {
                    options = this.graqlShellOptionsFactory.createGraqlShellOptions(this.valuesFrom(args, 1));
                }
                catch (ParseException e) {
                    System.err.println(e.getMessage());
                    return;
                }
                GraqlConsole.start((GraqlShellOptions)options, (String)HISTORY_FILENAME, (PrintStream)System.out, (PrintStream)System.err);
                break;
            }
            case "migrate": {
                this.migrate(this.valuesFrom(args, 1));
                break;
            }
            case "version": {
                this.version();
                break;
            }
            default: {
                this.help();
            }
        }
    }

    private void migrate(String[] args) {
        String option;
        switch (option = args.length > 0 ? args[0] : "") {
            case "csv": {
                CSVMigrator.main((String[])this.valuesFrom(args, 1));
                break;
            }
            case "json": {
                JsonMigrator.main((String[])this.valuesFrom(args, 1));
                break;
            }
            case "owl": {
                System.err.println(ErrorMessage.OWL_NOT_SUPPORTED.getMessage(new Object[0]));
                break;
            }
            case "export": {
                Main.main((String[])this.valuesFrom(args, 1));
                break;
            }
            case "sql": {
                SQLMigrator.main((String[])this.valuesFrom(args, 1));
                break;
            }
            case "xml": {
                XmlMigrator.main((String[])this.valuesFrom(args, 1));
                break;
            }
            default: {
                this.help();
            }
        }
    }

    private String[] valuesFrom(String[] args, int index) {
        return Arrays.copyOfRange(args, index, args.length);
    }

    private void help() {
        System.out.println("Usage: graql COMMAND\n\nCOMMAND:\nconsole  Start a REPL console for running Graql queries. Defaults to connecting to http://localhost\nmigrate  Run migration from a file\nversion  Print Grakn version\nhelp     Print this message");
    }

    private void version() {
        System.out.println("1.4.0");
    }
}

