/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.BootupException;
import ai.grakn.engine.bootup.BootupProcessExecutor;
import ai.grakn.engine.bootup.BootupProcessResult;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Arrays;

public class QueueBootup {
    private static final String DISPLAY_NAME = "Queue";
    private static final String QUEUE_PROCESS_NAME = "redis-server";
    private static final long QUEUE_STARTUP_TIMEOUT_SECOND = 10L;
    private static final Path QUEUE_CONFIG_PATH = Paths.get("services", "redis", "redis.conf");
    private static final Path QUEUE_PIDFILE = Paths.get(File.separator, "tmp", "grakn-queue.pid");
    private final Path QUEUE_SERVER_BIN;
    private final Path QUEUE_CLI_BIN;
    private BootupProcessExecutor bootupProcessExecutor;
    private final Path graknHome;

    public QueueBootup(BootupProcessExecutor bootupProcessExecutor, Path graknHome) {
        this.graknHome = graknHome;
        this.bootupProcessExecutor = bootupProcessExecutor;
        this.QUEUE_SERVER_BIN = Paths.get("services", "redis", this.selectCommand("redis-server-osx", "redis-server-linux"));
        this.QUEUE_CLI_BIN = Paths.get("services", "redis", this.selectCommand("redis-cli-osx", "redis-cli-linux"));
    }

    public void startIfNotRunning() {
        boolean queueRunning = this.bootupProcessExecutor.isProcessRunning(QUEUE_PIDFILE);
        if (queueRunning) {
            System.out.println("Queue is already running");
        } else {
            this.start();
        }
    }

    public void stop() {
        System.out.print("Stopping Queue...");
        System.out.flush();
        boolean queueIsRunning = this.bootupProcessExecutor.isProcessRunning(QUEUE_PIDFILE);
        if (!queueIsRunning) {
            System.out.println("NOT RUNNING");
        } else {
            this.queueStopProcess();
        }
    }

    public void status() {
        this.bootupProcessExecutor.processStatus(QUEUE_PIDFILE, DISPLAY_NAME);
    }

    public void statusVerbose() {
        System.out.println("Queue pid = '" + this.bootupProcessExecutor.getPidFromFile(QUEUE_PIDFILE).orElse("") + "' (from " + QUEUE_PIDFILE + "), '" + this.bootupProcessExecutor.getPidFromPsOf(QUEUE_PROCESS_NAME) + "' (from ps -ef)");
    }

    public void clean() {
        System.out.print("Cleaning Queue...");
        System.out.flush();
        this.startIfNotRunning();
        this.bootupProcessExecutor.executeAndWait(Arrays.asList(this.QUEUE_CLI_BIN.toString(), "flushall"), this.graknHome.toFile());
        this.stop();
        System.out.println("SUCCESS");
    }

    public boolean isRunning() {
        return this.bootupProcessExecutor.isProcessRunning(QUEUE_PIDFILE);
    }

    private void start() {
        System.out.print("Starting Queue...");
        System.out.flush();
        BootupProcessResult startQueue = this.bootupProcessExecutor.executeAndWait(Arrays.asList(this.QUEUE_SERVER_BIN.toString(), QUEUE_CONFIG_PATH.toString()), this.graknHome.toFile());
        LocalDateTime timeout = LocalDateTime.now().plusSeconds(10L);
        while (LocalDateTime.now().isBefore(timeout)) {
            System.out.print(".");
            System.out.flush();
            if (this.bootupProcessExecutor.isProcessRunning(QUEUE_PIDFILE)) {
                System.out.println("SUCCESS");
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        String errorMessage = "Process exited with code " + startQueue.exitCode() + ": '" + startQueue.stderr() + "'";
        System.out.println("FAILED!");
        System.err.println("Unable to start Queue. " + errorMessage);
        throw new BootupException();
    }

    private void queueStopProcess() {
        int pid = this.bootupProcessExecutor.retrievePid(QUEUE_PIDFILE);
        if (pid < 0) {
            return;
        }
        String host = this.getHostFromConfig();
        this.bootupProcessExecutor.executeAndWait(Arrays.asList(this.QUEUE_CLI_BIN.toString(), "-h", host, "shutdown"), this.graknHome.toFile());
        this.bootupProcessExecutor.waitUntilStopped(QUEUE_PIDFILE, pid);
    }

    private String getHostFromConfig() {
        Path fileLocation = this.graknHome.resolve(QUEUE_CONFIG_PATH);
        return (String)GraknConfig.read((File)fileLocation.toFile()).getProperty(GraknConfigKey.REDIS_BIND);
    }

    private String selectCommand(String osx, String linux) {
        BootupProcessResult operatingSystem = this.bootupProcessExecutor.executeAndWait(Arrays.asList("/bin/sh", "-c", "uname"), null);
        return operatingSystem.stdout().trim().equals("Darwin") ? osx : linux;
    }
}

