/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.BootupException;
import ai.grakn.engine.bootup.BootupProcessExecutor;
import ai.grakn.engine.bootup.BootupProcessResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class StorageBootup {
    private static final String DISPLAY_NAME = "Storage";
    private static final String STORAGE_PROCESS_NAME = "CassandraDaemon";
    private static final long STORAGE_STARTUP_TIMEOUT_SECOND = 60L;
    private static final Path STORAGE_PIDFILE = Paths.get(File.separator, "tmp", "grakn-storage.pid");
    private static final Path STORAGE_BIN = Paths.get("services", "cassandra", "cassandra");
    private static final Path NODETOOL_BIN = Paths.get("services", "cassandra", "nodetool");
    private static final Path STORAGE_DATA = Paths.get("db", "cassandra");
    private BootupProcessExecutor bootupProcessExecutor;
    private final Path graknHome;
    private final GraknConfig graknProperties;

    public StorageBootup(BootupProcessExecutor bootupProcessExecutor, Path graknHome, Path graknPropertiesPath) {
        this.graknHome = graknHome;
        this.graknProperties = GraknConfig.read((File)graknPropertiesPath.toFile());
        this.bootupProcessExecutor = bootupProcessExecutor;
    }

    public void startIfNotRunning() {
        boolean isStorageRunning = this.bootupProcessExecutor.isProcessRunning(STORAGE_PIDFILE);
        if (isStorageRunning) {
            System.out.println("Storage is already running");
        } else {
            FileUtils.deleteQuietly((File)STORAGE_PIDFILE.toFile());
            this.start();
        }
    }

    public void stop() {
        this.bootupProcessExecutor.stopProcessIfRunning(STORAGE_PIDFILE, DISPLAY_NAME);
    }

    public void status() {
        this.bootupProcessExecutor.processStatus(STORAGE_PIDFILE, DISPLAY_NAME);
    }

    public void statusVerbose() {
        System.out.println("Storage pid = '" + this.bootupProcessExecutor.getPidFromFile(STORAGE_PIDFILE).orElse("") + "' (from " + STORAGE_PIDFILE + "), '" + this.bootupProcessExecutor.getPidFromPsOf(STORAGE_PROCESS_NAME) + "' (from ps -ef)");
    }

    public void clean() {
        System.out.print("Cleaning Storage...");
        System.out.flush();
        try (Stream<Path> files = Files.walk(STORAGE_DATA, new FileVisitOption[0]);){
            files.map(Path::toFile).sorted(Comparator.comparing(File::isDirectory)).forEach(File::delete);
            Files.createDirectories(this.graknHome.resolve(STORAGE_DATA).resolve("data"), new FileAttribute[0]);
            Files.createDirectories(this.graknHome.resolve(STORAGE_DATA).resolve("commitlog"), new FileAttribute[0]);
            Files.createDirectories(this.graknHome.resolve(STORAGE_DATA).resolve("saved_caches"), new FileAttribute[0]);
            System.out.println("SUCCESS");
        }
        catch (IOException e) {
            System.out.println("FAILED!");
            System.out.println("Unable to clean Storage");
        }
    }

    public boolean isRunning() {
        return this.bootupProcessExecutor.isProcessRunning(STORAGE_PIDFILE);
    }

    private void start() {
        List<String> storageCmd = Arrays.asList(STORAGE_BIN.toString(), "-p", STORAGE_PIDFILE.toString(), "-l", this.getStorageLogPathFromGraknProperties().toAbsolutePath().toString());
        List<String> storageCmd_EscapeWhitespace = storageCmd.stream().map(string -> string.replace(" ", "\\ ")).collect(Collectors.toList());
        List<String> isStorageRunningCmd_EscapeWhitespace = Arrays.asList("/bin/sh", "-c", NODETOOL_BIN.toString().replace(" ", "\\ ") + " statusthrift | tr -d '\n\r'");
        System.out.print("Starting Storage...");
        System.out.flush();
        BootupProcessResult startStorage = this.bootupProcessExecutor.executeAndWait(storageCmd_EscapeWhitespace, this.graknHome.toFile());
        LocalDateTime timeout = LocalDateTime.now().plusSeconds(60L);
        while (LocalDateTime.now().isBefore(timeout) && startStorage.exitCode() == 0) {
            System.out.print(".");
            System.out.flush();
            BootupProcessResult isStorageRunning = this.bootupProcessExecutor.executeAndWait(isStorageRunningCmd_EscapeWhitespace, this.graknHome.toFile());
            if (isStorageRunning.stdout().trim().equals("running")) {
                System.out.println("SUCCESS");
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        String errorMessage = "Process exited with code " + startStorage.exitCode() + ": '" + startStorage.stderr() + "'";
        System.out.println("FAILED!");
        System.err.println("Unable to start Storage. ");
        System.err.println(errorMessage);
        throw new BootupException();
    }

    private Path getStorageLogPathFromGraknProperties() {
        return Paths.get((String)this.graknProperties.getProperty(GraknConfigKey.LOG_DIR), new String[0]);
    }
}

