/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup.config;

import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.config.Configs;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ConfigProcessor {
    public static String getConfigStringFromFile(Path configPath) {
        try {
            byte[] bytes = Files.readAllBytes(configPath);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveConfigStringToFile(String configString, Path configPath) {
        try {
            Files.write(configPath, configString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateStorageConfig() {
        GraknConfig graknConfig = Configs.graknConfig();
        String updatedStorageConfigString = Configs.storageConfig().updateFromConfig(graknConfig).toConfigString();
        ConfigProcessor.saveConfigStringToFile(updatedStorageConfigString, Configs.storageConfigPath());
    }

    public static void updateQueueConfig() {
        GraknConfig graknConfig = Configs.graknConfig();
        String updatedQueueConfigString = Configs.queueConfig().updateFromConfig(graknConfig).toConfigString();
        ConfigProcessor.saveConfigStringToFile(updatedQueueConfigString, Configs.queueConfigPath());
    }

    public static void updateProcessConfigs() {
        ConfigProcessor.updateStorageConfig();
        ConfigProcessor.updateQueueConfig();
    }
}

