/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup.config;

import ai.grakn.GraknSystemProperty;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.config.QueueConfig;
import ai.grakn.engine.bootup.config.StorageConfig;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Configs {
    private static final String STORAGE_CONFIG_PATH = "services/cassandra/";
    private static final String STORAGE_CONFIG_NAME = "cassandra.yaml";
    private static final String QUEUE_CONFIG_PATH = "services/redis/";
    private static final String QUEUE_CONFIG_NAME = "redis.conf";

    public static GraknConfig graknConfig() {
        return GraknConfig.read((File)Configs.graknConfigPath().toFile());
    }

    public static QueueConfig queueConfig() {
        return QueueConfig.from(Configs.queueConfigPath());
    }

    public static StorageConfig storageConfig() {
        return StorageConfig.from(Configs.storageConfigPath());
    }

    public static Path graknConfigPath() {
        return Paths.get(GraknSystemProperty.CONFIGURATION_FILE.value(), new String[0]);
    }

    public static Path queueConfigPath() {
        return Paths.get(QUEUE_CONFIG_PATH, QUEUE_CONFIG_NAME);
    }

    public static Path storageConfigPath() {
        return Paths.get(STORAGE_CONFIG_PATH, STORAGE_CONFIG_NAME);
    }
}

