/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup.config;

import ai.grakn.engine.GraknConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public abstract class ProcessConfig<V> {
    private final ImmutableMap<String, V> params;

    ProcessConfig(Map<String, V> params) {
        this.params = ImmutableMap.copyOf(params);
    }

    public ImmutableMap<String, V> params() {
        return this.params;
    }

    Map<String, V> updateParamsFromMap(Map<String, V> newParams) {
        HashMap updatedParams = Maps.newHashMap(this.params());
        updatedParams.putAll(newParams);
        return updatedParams;
    }

    Map<String, V> updateParamsFromConfig(String CONFIG_PARAM_PREFIX, GraknConfig config) {
        HashMap updatedParams = Maps.newHashMap(this.params());
        config.properties().stringPropertyNames().stream().filter(prop -> prop.contains(CONFIG_PARAM_PREFIX)).forEach(prop -> {
            String param = prop.replaceAll(CONFIG_PARAM_PREFIX, "");
            if (updatedParams.containsKey(param)) {
                Map.Entry<String, V> entry = this.propToEntry(param, (String)prop);
                updatedParams.put(entry.getKey(), entry.getValue());
            }
        });
        return updatedParams;
    }

    abstract Map.Entry<String, V> propToEntry(String var1, String var2);

    public abstract String toConfigString();

    public abstract ProcessConfig updateGenericParams(GraknConfig var1);

    public abstract ProcessConfig updateFromConfig(GraknConfig var1);
}

