/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup.config;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.config.ProcessConfig;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class QueueConfig
extends ProcessConfig<List<Object>> {
    private static final String CONFIG_PARAM_PREFIX = "queue.internal.";
    private static final String LOG_FILE = "grakn-queue.log";
    private static final String DATA_SUBDIR = "redis/";
    private static final String DB_DIR_CONFIG_KEY = "dir";
    private static final String LOG_DIR_CONFIG_KEY = "logfile";
    private static final String RECORD_SEPARATOR = "\n";
    private static final String KEY_VALUE_SEPARATOR = " ";

    private QueueConfig(Map<String, List<Object>> params) {
        super(params);
    }

    public static QueueConfig of(Map<String, List<Object>> params) {
        return new QueueConfig(params);
    }

    public static QueueConfig from(Path configPath) {
        return QueueConfig.of(QueueConfig.parseFileToMap(configPath));
    }

    private static Map<String, List<Object>> parseFileToMap(Path configPath) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        try {
            PropertiesConfiguration props = new PropertiesConfiguration(configPath.toFile());
            props.getKeys().forEachRemaining(key -> map.put((String)key, props.getList(key)));
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    Map.Entry<String, List<Object>> propToEntry(String param, String value) {
        return new AbstractMap.SimpleImmutableEntry<String, List<Object>>(param, Collections.singletonList(value));
    }

    @Override
    public String toConfigString() {
        return this.params().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(value -> new AbstractMap.SimpleImmutableEntry(e.getKey(), value))).map(e -> (String)e.getKey() + KEY_VALUE_SEPARATOR + e.getValue()).collect(Collectors.joining(RECORD_SEPARATOR));
    }

    private Path getAbsoluteLogPath(GraknConfig config) {
        Path projectPath = GraknConfig.PROJECT_PATH;
        String logPathString = (String)config.getProperty(GraknConfigKey.LOG_DIR) + LOG_FILE;
        Path logPath = Paths.get(logPathString, new String[0]);
        return logPath.isAbsolute() ? logPath : Paths.get(projectPath.toString(), logPathString);
    }

    private QueueConfig updateDirs(GraknConfig config) {
        String dbDir = (String)config.getProperty(GraknConfigKey.DATA_DIR);
        ImmutableMap dirParams = ImmutableMap.of((Object)DB_DIR_CONFIG_KEY, Collections.singletonList("\"" + dbDir + DATA_SUBDIR + "\""), (Object)LOG_DIR_CONFIG_KEY, Collections.singletonList("\"" + this.getAbsoluteLogPath(config) + "\""));
        return new QueueConfig(this.updateParamsFromMap(dirParams));
    }

    @Override
    public QueueConfig updateGenericParams(GraknConfig config) {
        return new QueueConfig(this.updateParamsFromConfig(CONFIG_PARAM_PREFIX, config));
    }

    @Override
    public QueueConfig updateFromConfig(GraknConfig config) {
        return this.updateGenericParams(config).updateDirs(config);
    }
}

