/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.bootup.config;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.bootup.config.ConfigProcessor;
import ai.grakn.engine.bootup.config.ProcessConfig;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StorageConfig
extends ProcessConfig<Object> {
    private static final String EMPTY_VALUE = "";
    private static final String CONFIG_PARAM_PREFIX = "storage.internal.";
    private static final String SAVED_CACHES_SUBDIR = "cassandra/saved_caches";
    private static final String COMMITLOG_SUBDIR = "cassandra/commitlog";
    private static final String DATA_SUBDIR = "cassandra/data";
    private static final String DATA_FILE_DIR_CONFIG_KEY = "data_file_directories";
    private static final String SAVED_CACHES_DIR_CONFIG_KEY = "saved_caches_directory";
    private static final String COMMITLOG_DIR_CONFIG_KEY = "commitlog_directory";

    private StorageConfig(Map<String, Object> yamlParams) {
        super(yamlParams);
    }

    public static StorageConfig of(String yaml) {
        return new StorageConfig(StorageConfig.parseStringToMap(yaml));
    }

    public static StorageConfig from(Path configPath) {
        String configString = ConfigProcessor.getConfigStringFromFile(configPath);
        return StorageConfig.of(configString);
    }

    private static Map<String, Object> parseStringToMap(String yaml) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));
        try {
            TypeReference<Map<String, Object>> reference = new TypeReference<Map<String, Object>>(){};
            Map yamlParams = (Map)mapper.readValue(yaml, (TypeReference)reference);
            return Maps.transformValues((Map)yamlParams, value -> value == null ? EMPTY_VALUE : value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    Map.Entry<String, Object> propToEntry(String key, String value) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    @Override
    public String toConfigString() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));
        try {
            ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)outputstream, this.params());
            return outputstream.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private StorageConfig updateDirs(GraknConfig config) {
        String dbDir = (String)config.getProperty(GraknConfigKey.DATA_DIR);
        ImmutableMap dirParams = ImmutableMap.of((Object)DATA_FILE_DIR_CONFIG_KEY, Collections.singletonList(dbDir + DATA_SUBDIR), (Object)SAVED_CACHES_DIR_CONFIG_KEY, (Object)(dbDir + SAVED_CACHES_SUBDIR), (Object)COMMITLOG_DIR_CONFIG_KEY, (Object)(dbDir + COMMITLOG_SUBDIR));
        return new StorageConfig(this.updateParamsFromMap(dirParams));
    }

    @Override
    Map<String, Object> updateParamsFromConfig(String CONFIG_PARAM_PREFIX, GraknConfig config) {
        HashMap updatedParams = Maps.newHashMap(this.params());
        config.properties().stringPropertyNames().stream().filter(prop -> prop.contains(CONFIG_PARAM_PREFIX)).forEach(prop -> {
            String param = prop.replaceAll(CONFIG_PARAM_PREFIX, EMPTY_VALUE);
            if (updatedParams.containsKey(param)) {
                updatedParams.put(param, config.properties().getProperty((String)prop));
            }
        });
        return updatedParams;
    }

    @Override
    public StorageConfig updateGenericParams(GraknConfig config) {
        return new StorageConfig(this.updateParamsFromConfig(CONFIG_PARAM_PREFIX, config));
    }

    @Override
    public StorageConfig updateFromConfig(GraknConfig config) {
        return this.updateGenericParams(config).updateDirs(config);
    }
}

